/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Tracing;
import brave.internal.Nullable;
import brave.internal.PredefinedPropagationFields;
import brave.internal.PropagationFields;
import brave.internal.PropagationFieldsFactory;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class ExtraFieldPropagation<K>
implements Propagation<K> {
    final Factory factory;
    final Propagation<K> delegate;
    final List<K> keys;
    final BitSet redacted;

    public static Factory newFactory(Propagation.Factory delegate, String ... fieldNames) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames == null");
        }
        String[] validated = ExtraFieldPropagation.ensureLowerCase(new LinkedHashSet<String>(Arrays.asList(fieldNames)));
        return new Factory(delegate, validated, validated, new BitSet());
    }

    public static Factory newFactory(Propagation.Factory delegate, Collection<String> fieldNames) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames == null");
        }
        String[] validated = ExtraFieldPropagation.ensureLowerCase(new LinkedHashSet<String>(fieldNames));
        return new Factory(delegate, validated, validated, new BitSet());
    }

    public static FactoryBuilder newFactoryBuilder(Propagation.Factory delegate) {
        return new FactoryBuilder(delegate);
    }

    @Nullable
    public static String current(String name) {
        return ExtraFieldPropagation.get(name);
    }

    @Nullable
    public static String get(String name) {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        return context != null ? ExtraFieldPropagation.get(context, name) : null;
    }

    public static void set(String name, String value) {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        if (context != null) {
            ExtraFieldPropagation.set(context, name, value);
        }
    }

    public static Map<String, String> getAll() {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        if (context == null) {
            return Collections.emptyMap();
        }
        return ExtraFieldPropagation.getAll(context);
    }

    public static Map<String, String> getAll(TraceContextOrSamplingFlags extracted) {
        if (extracted == null) {
            throw new NullPointerException("extracted == null");
        }
        TraceContext extractedContext = extracted.context();
        if (extractedContext != null) {
            return ExtraFieldPropagation.getAll(extractedContext);
        }
        Extra fields = TraceContext.findExtra(Extra.class, extracted.extra());
        return fields != null ? fields.toMap() : Collections.emptyMap();
    }

    public static Map<String, String> getAll(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        Extra fields = context.findExtra(Extra.class);
        return fields != null ? fields.toMap() : Collections.emptyMap();
    }

    @Nullable
    static TraceContext currentTraceContext() {
        Tracing tracing = Tracing.current();
        return tracing != null ? tracing.currentTraceContext().get() : null;
    }

    @Nullable
    public static String get(TraceContext context, String name) {
        return (String)PropagationFields.get(context, ExtraFieldPropagation.lowercase(name), Extra.class);
    }

    public static void set(TraceContext context, String name, String value) {
        PropagationFields.put(context, ExtraFieldPropagation.lowercase(name), value, Extra.class);
    }

    ExtraFieldPropagation(Factory factory, Propagation.KeyFactory<K> keyFactory, List<K> keys, BitSet redacted) {
        this.factory = factory;
        this.delegate = factory.delegate.create(keyFactory);
        this.keys = keys;
        this.redacted = redacted;
    }

    public List<K> extraKeys() {
        return this.keys;
    }

    @Override
    public List<K> keys() {
        return this.delegate.keys();
    }

    @Override
    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        return new ExtraFieldInjector<C, K>(this, setter);
    }

    @Override
    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        return new ExtraFieldExtractor<C, K>(this, getter);
    }

    static String[] ensureLowerCase(Collection<String> names) {
        if (names.isEmpty()) {
            throw new IllegalArgumentException("names is empty");
        }
        Iterator<String> nextName = names.iterator();
        String[] result = new String[names.size()];
        int i = 0;
        while (nextName.hasNext()) {
            String name = nextName.next();
            if (name == null) {
                throw new NullPointerException("names[" + i + "] == null");
            }
            if ((name = name.trim()).isEmpty()) {
                throw new IllegalArgumentException("names[" + i + "] is empty");
            }
            result[i] = name.toLowerCase(Locale.ROOT);
            ++i;
        }
        return result;
    }

    static String lowercase(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return name.toLowerCase(Locale.ROOT);
    }

    static String validateFieldName(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName == null");
        }
        if ((fieldName = fieldName.toLowerCase(Locale.ROOT).trim()).isEmpty()) {
            throw new IllegalArgumentException("fieldName is empty");
        }
        return fieldName;
    }

    static final class Extra
    extends PredefinedPropagationFields {
        Extra(String ... fieldNames) {
            super(fieldNames);
        }

        Extra(Extra parent, String ... fieldNames) {
            super(parent, fieldNames);
        }
    }

    static final class ExtraFactory
    extends PropagationFieldsFactory<String, String, Extra> {
        final String[] fieldNames;

        ExtraFactory(String[] fieldNames) {
            this.fieldNames = fieldNames;
        }

        @Override
        public Class<Extra> type() {
            return Extra.class;
        }

        @Override
        protected Extra create() {
            return new Extra(this.fieldNames);
        }

        @Override
        protected Extra create(Extra parent) {
            return new Extra(parent, this.fieldNames);
        }

        @Override
        protected TraceContext contextWithExtra(TraceContext context, List<Object> extra) {
            return context.withExtra(extra);
        }
    }

    static final class ExtraFieldExtractor<C, K>
    implements TraceContext.Extractor<C> {
        final ExtraFieldPropagation<K> propagation;
        final TraceContext.Extractor<C> delegate;
        final Propagation.Getter<C, K> getter;

        ExtraFieldExtractor(ExtraFieldPropagation<K> propagation, Propagation.Getter<C, K> getter) {
            this.propagation = propagation;
            this.delegate = propagation.delegate.extractor(getter);
            this.getter = getter;
        }

        @Override
        public TraceContextOrSamplingFlags extract(C carrier) {
            TraceContextOrSamplingFlags result = this.delegate.extract(carrier);
            Extra fields = this.propagation.factory.extraFactory.create();
            int length = this.propagation.keys.size();
            for (int i = 0; i < length; ++i) {
                String maybeValue = this.getter.get(carrier, this.propagation.keys.get(i));
                if (maybeValue == null) continue;
                fields.put(this.propagation.factory.keyToField[i], maybeValue);
            }
            return result.toBuilder().addExtra(fields).build();
        }
    }

    static final class ExtraFieldInjector<C, K>
    implements TraceContext.Injector<C> {
        final ExtraFieldPropagation<K> propagation;
        final TraceContext.Injector<C> delegate;
        final Propagation.Setter<C, K> setter;

        ExtraFieldInjector(ExtraFieldPropagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.propagation = propagation;
            this.delegate = propagation.delegate.injector(setter);
            this.setter = setter;
        }

        @Override
        public void inject(TraceContext traceContext, C carrier) {
            this.delegate.inject(traceContext, carrier);
            Extra extra = traceContext.findExtra(Extra.class);
            if (extra == null) {
                return;
            }
            this.inject(extra, carrier);
        }

        void inject(Extra fields, C carrier) {
            int length = this.propagation.keys.size();
            for (int i = 0; i < length; ++i) {
                String maybeValue;
                if (this.propagation.redacted.get(i) || (maybeValue = fields.get(this.propagation.factory.keyToField[i])) == null) continue;
                this.setter.put(carrier, this.propagation.keys.get(i), maybeValue);
            }
        }
    }

    public static final class Factory
    extends Propagation.Factory {
        final Propagation.Factory delegate;
        final String[] fieldNames;
        final String[] keyNames;
        final int[] keyToField;
        final BitSet redacted;
        final ExtraFactory extraFactory;

        Factory(Propagation.Factory delegate, String[] fieldNames, String[] keyNames, BitSet redacted) {
            this(delegate, fieldNames, keyNames, Factory.keyToField(keyNames), redacted);
        }

        static int[] keyToField(String[] keyNames) {
            int[] result = new int[keyNames.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = i;
            }
            return result;
        }

        Factory(Propagation.Factory delegate, String[] fieldNames, String[] keyNames, int[] keyToField, BitSet redacted) {
            this.delegate = delegate;
            this.keyToField = keyToField;
            this.fieldNames = fieldNames;
            this.keyNames = keyNames;
            this.redacted = redacted;
            this.extraFactory = new ExtraFactory(fieldNames);
        }

        @Override
        public boolean supportsJoin() {
            return this.delegate.supportsJoin();
        }

        @Override
        public boolean requires128BitTraceId() {
            return this.delegate.requires128BitTraceId();
        }

        public final <K> ExtraFieldPropagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            int length = this.keyNames.length;
            ArrayList<K> keys = new ArrayList<K>(length);
            for (int i = 0; i < length; ++i) {
                keys.add(keyFactory.create(this.keyNames[i]));
            }
            return new ExtraFieldPropagation<K>(this, keyFactory, keys, this.redacted);
        }

        @Override
        public TraceContext decorate(TraceContext context) {
            TraceContext result = this.delegate.decorate(context);
            return this.extraFactory.decorate(result);
        }
    }

    public static final class FactoryBuilder {
        final Propagation.Factory delegate;
        final Set<String> fieldNames = new LinkedHashSet<String>();
        final Set<String> redactedFieldNames = new LinkedHashSet<String>();
        final Map<String, String[]> prefixedNames = new LinkedHashMap<String, String[]>();

        FactoryBuilder(Propagation.Factory delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate == null");
            }
            this.delegate = delegate;
        }

        public FactoryBuilder addRedactedField(String fieldName) {
            fieldName = ExtraFieldPropagation.validateFieldName(fieldName);
            this.fieldNames.add(fieldName);
            this.redactedFieldNames.add(fieldName);
            return this;
        }

        public FactoryBuilder addField(String fieldName) {
            this.fieldNames.add(ExtraFieldPropagation.validateFieldName(fieldName));
            return this;
        }

        public FactoryBuilder addPrefixedFields(String prefix, Collection<String> fieldNames) {
            if (prefix == null) {
                throw new NullPointerException("prefix == null");
            }
            if (prefix.isEmpty()) {
                throw new IllegalArgumentException("prefix is empty");
            }
            if (fieldNames == null) {
                throw new NullPointerException("fieldNames == null");
            }
            this.prefixedNames.put(prefix, ExtraFieldPropagation.ensureLowerCase(new LinkedHashSet<String>(fieldNames)));
            return this;
        }

        public Factory build() {
            BitSet redacted = new BitSet();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<Integer> keyToFieldList = new ArrayList<Integer>();
            int i = 0;
            for (String string : this.fieldNames) {
                if (this.redactedFieldNames.contains(string)) {
                    redacted.set(i);
                }
                fields.add(string);
                keys.add(string);
                keyToFieldList.add(i++);
            }
            for (Map.Entry entry : this.prefixedNames.entrySet()) {
                String nextPrefix = (String)entry.getKey();
                String[] nextFieldNames = (String[])entry.getValue();
                for (i = 0; i < nextFieldNames.length; ++i) {
                    String nextFieldName = nextFieldNames[i];
                    int index = fields.indexOf(nextFieldName);
                    if (index == -1) {
                        index = fields.size();
                        fields.add(nextFieldName);
                    }
                    keys.add(nextPrefix + nextFieldName);
                    keyToFieldList.add(index);
                }
            }
            int[] keyToField = new int[keys.size()];
            for (i = 0; i < keyToField.length; ++i) {
                keyToField[i] = (Integer)keyToFieldList.get(i);
            }
            return new Factory(this.delegate, fields.toArray(new String[0]), keys.toArray(new String[0]), keyToField, redacted);
        }
    }
}

