/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.ErrorParser;
import brave.Tracing;
import brave.http.HttpClientParser;
import brave.http.HttpRequest;
import brave.http.HttpSampler;
import brave.http.HttpServerParser;
import brave.sampler.SamplerFunction;
import brave.sampler.SamplerFunctions;

public class HttpTracing {
    final Tracing tracing;
    final HttpClientParser clientParser;
    final String serverName;
    final HttpServerParser serverParser;
    final SamplerFunction<HttpRequest> clientSampler;
    final SamplerFunction<HttpRequest> serverSampler;

    public static HttpTracing create(Tracing tracing) {
        return HttpTracing.newBuilder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    public Tracing tracing() {
        return this.tracing;
    }

    public HttpClientParser clientParser() {
        return this.clientParser;
    }

    public String serverName() {
        return this.serverName;
    }

    public HttpTracing clientOf(String serverName) {
        return this.toBuilder().serverName(serverName).build();
    }

    public HttpServerParser serverParser() {
        return this.serverParser;
    }

    @Deprecated
    public HttpSampler clientSampler() {
        return HttpSampler.fromHttpRequestSampler(this.clientSampler);
    }

    public SamplerFunction<HttpRequest> clientRequestSampler() {
        return this.clientSampler;
    }

    @Deprecated
    public HttpSampler serverSampler() {
        return HttpSampler.fromHttpRequestSampler(this.serverSampler);
    }

    public SamplerFunction<HttpRequest> serverRequestSampler() {
        return this.serverSampler;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    HttpTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.clientParser = builder.clientParser;
        this.serverName = builder.serverName;
        this.serverParser = builder.serverParser;
        this.clientSampler = builder.clientSampler;
        this.serverSampler = builder.serverSampler;
    }

    public static final class Builder {
        Tracing tracing;
        HttpClientParser clientParser;
        String serverName;
        HttpServerParser serverParser;
        SamplerFunction<HttpRequest> clientSampler;
        SamplerFunction<HttpRequest> serverSampler;

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            final ErrorParser errorParser = tracing.errorParser();
            this.tracing = tracing;
            this.serverName = "";
            this.clientParser = new HttpClientParser(){

                @Override
                protected ErrorParser errorParser() {
                    return errorParser;
                }
            };
            this.serverParser = new HttpServerParser(){

                @Override
                protected ErrorParser errorParser() {
                    return errorParser;
                }
            };
            this.clientSampler = SamplerFunctions.deferDecision();
            this.serverSampler = SamplerFunctions.deferDecision();
        }

        Builder(HttpTracing source) {
            this.tracing = source.tracing;
            this.clientParser = source.clientParser;
            this.serverName = source.serverName;
            this.serverParser = source.serverParser;
            this.clientSampler = source.clientSampler;
            this.serverSampler = source.serverSampler;
        }

        public Builder tracing(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
            return this;
        }

        public Builder clientParser(HttpClientParser clientParser) {
            if (clientParser == null) {
                throw new NullPointerException("clientParser == null");
            }
            this.clientParser = clientParser;
            return this;
        }

        Builder serverName(String serverName) {
            if (serverName == null) {
                throw new NullPointerException("serverName == null");
            }
            this.serverName = serverName;
            return this;
        }

        public Builder serverParser(HttpServerParser serverParser) {
            if (serverParser == null) {
                throw new NullPointerException("serverParser == null");
            }
            this.serverParser = serverParser;
            return this;
        }

        public Builder clientSampler(HttpSampler clientSampler) {
            if (clientSampler == null) {
                throw new NullPointerException("clientSampler == null");
            }
            return this.clientSampler((SamplerFunction<HttpRequest>)clientSampler);
        }

        public Builder clientSampler(SamplerFunction<HttpRequest> clientSampler) {
            if (clientSampler == null) {
                throw new NullPointerException("clientSampler == null");
            }
            this.clientSampler = HttpSampler.toHttpRequestSampler(clientSampler);
            return this;
        }

        public Builder serverSampler(HttpSampler serverSampler) {
            return this.serverSampler((SamplerFunction<HttpRequest>)serverSampler);
        }

        public Builder serverSampler(SamplerFunction<HttpRequest> serverSampler) {
            if (serverSampler == null) {
                throw new NullPointerException("serverSampler == null");
            }
            this.serverSampler = HttpSampler.toHttpRequestSampler(serverSampler);
            return this;
        }

        public HttpTracing build() {
            return new HttpTracing(this);
        }
    }
}

