/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.kafka.clients.KafkaTracing;
import brave.kafka.streams.AbstractTracingTransformer;
import brave.kafka.streams.AbstractTracingValueTransformer;
import brave.kafka.streams.AbstractTracingValueTransformerWithKey;
import brave.kafka.streams.KafkaStreamsPropagation;
import brave.kafka.streams.TracingFilterTransformerSupplier;
import brave.kafka.streams.TracingFilterValueTransformerWithKeySupplier;
import brave.kafka.streams.TracingKafkaClientSupplier;
import brave.kafka.streams.TracingProcessorSupplier;
import brave.kafka.streams.TracingTransformerSupplier;
import brave.kafka.streams.TracingValueTransformerSupplier;
import brave.kafka.streams.TracingValueTransformerWithKeySupplier;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Properties;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

public final class KafkaStreamsTracing {
    final Tracing tracing;
    final TraceContext.Extractor<Headers> extractor;
    final TraceContext.Injector<Headers> injector;

    KafkaStreamsTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.extractor = this.tracing.propagation().extractor(KafkaStreamsPropagation.GETTER);
        this.injector = this.tracing.propagation().injector(KafkaStreamsPropagation.SETTER);
    }

    public static KafkaStreamsTracing create(Tracing tracing) {
        return new Builder(tracing).build();
    }

    public KafkaClientSupplier kafkaClientSupplier() {
        KafkaTracing kafkaTracing = KafkaTracing.create((Tracing)this.tracing);
        return new TracingKafkaClientSupplier(kafkaTracing);
    }

    public KafkaStreams kafkaStreams(Topology topology, Properties streamsConfig) {
        return new KafkaStreams(topology, streamsConfig, this.kafkaClientSupplier());
    }

    public <K, V> ProcessorSupplier<K, V> processor(String spanName, ProcessorSupplier<K, V> processorSupplier) {
        return new TracingProcessorSupplier<K, V>(this, spanName, processorSupplier);
    }

    public <K, V, R> TransformerSupplier<K, V, R> transformer(String spanName, TransformerSupplier<K, V, R> transformerSupplier) {
        return new TracingTransformerSupplier<K, V, R>(this, spanName, transformerSupplier);
    }

    public <V, VR> ValueTransformerSupplier<V, VR> valueTransformer(String spanName, ValueTransformerSupplier<V, VR> valueTransformerSupplier) {
        return new TracingValueTransformerSupplier<V, VR>(this, spanName, valueTransformerSupplier);
    }

    public <K, V, VR> ValueTransformerWithKeySupplier<K, V, VR> valueTransformerWithKey(String spanName, ValueTransformerWithKeySupplier<K, V, VR> valueTransformerWithKeySupplier) {
        return new TracingValueTransformerWithKeySupplier<K, V, VR>(this, spanName, valueTransformerWithKeySupplier);
    }

    public <K, V> ProcessorSupplier<K, V> foreach(String spanName, final ForeachAction<K, V> action) {
        return new TracingProcessorSupplier(this, spanName, () -> new AbstractProcessor<K, V>(){

            public void process(K key, V value) {
                action.apply(key, value);
            }
        });
    }

    public <K, V> ValueTransformerWithKeySupplier<K, V, V> peek(String spanName, final ForeachAction<K, V> action) {
        return new TracingValueTransformerWithKeySupplier(this, spanName, () -> new AbstractTracingValueTransformerWithKey<K, V, V>(){

            public V transform(K key, V value) {
                action.apply(key, value);
                return value;
            }
        });
    }

    public <K, V> ValueTransformerWithKeySupplier<K, V, V> mark(String spanName) {
        return new TracingValueTransformerWithKeySupplier(this, spanName, () -> new AbstractTracingValueTransformerWithKey<K, V, V>(){

            public V transform(K key, V value) {
                return value;
            }
        });
    }

    public <K, V, KR, VR> TransformerSupplier<K, V, KeyValue<KR, VR>> map(String spanName, final KeyValueMapper<K, V, KeyValue<KR, VR>> mapper) {
        return new TracingTransformerSupplier(this, spanName, () -> new AbstractTracingTransformer<K, V, KeyValue<KR, VR>>(){

            public KeyValue<KR, VR> transform(K key, V value) {
                return (KeyValue)mapper.apply(key, value);
            }
        });
    }

    public <K, V> TransformerSupplier<K, V, KeyValue<K, V>> filter(String spanName, Predicate<K, V> predicate) {
        return new TracingFilterTransformerSupplier<K, V>(this, spanName, predicate, false);
    }

    public <K, V> TransformerSupplier<K, V, KeyValue<K, V>> filterNot(String spanName, Predicate<K, V> predicate) {
        return new TracingFilterTransformerSupplier<K, V>(this, spanName, predicate, true);
    }

    public <K, V> ValueTransformerWithKeySupplier<K, V, V> markAsFiltered(String spanName, Predicate<K, V> predicate) {
        return new TracingFilterValueTransformerWithKeySupplier<K, V>(this, spanName, predicate, false);
    }

    public <K, V> ValueTransformerWithKeySupplier<K, V, V> markAsNotFiltered(String spanName, Predicate<K, V> predicate) {
        return new TracingFilterValueTransformerWithKeySupplier<K, V>(this, spanName, predicate, true);
    }

    public <K, V, VR> ValueTransformerWithKeySupplier<K, V, VR> mapValues(String spanName, final ValueMapperWithKey<K, V, VR> mapper) {
        return new TracingValueTransformerWithKeySupplier(this, spanName, () -> new AbstractTracingValueTransformerWithKey<K, V, VR>(){

            public VR transform(K readOnlyKey, V value) {
                return mapper.apply(readOnlyKey, value);
            }
        });
    }

    public <V, VR> ValueTransformerSupplier<V, VR> mapValues(String spanName, final ValueMapper<V, VR> mapper) {
        return new TracingValueTransformerSupplier(this, spanName, () -> new AbstractTracingValueTransformer<V, VR>(){

            public VR transform(V value) {
                return mapper.apply(value);
            }
        });
    }

    static void addTags(ProcessorContext processorContext, SpanCustomizer result) {
        result.tag("kafka.streams.application.id", processorContext.applicationId());
        result.tag("kafka.streams.task.id", processorContext.taskId().toString());
    }

    Span nextSpan(ProcessorContext context) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)context.headers());
        Span result = this.tracing.tracer().nextSpan(extracted);
        if (!result.isNoop()) {
            KafkaStreamsTracing.addTags(context, (SpanCustomizer)result);
        }
        return result;
    }

    public static final class Builder {
        final Tracing tracing;

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
        }

        public KafkaStreamsTracing build() {
            return new KafkaStreamsTracing(this);
        }
    }
}

