/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.processor.ProcessorContext;

class TracingValueTransformerWithKey<K, V, VR>
implements ValueTransformerWithKey<K, V, VR> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String spanName;
    final ValueTransformerWithKey<K, V, VR> delegateTransformer;
    ProcessorContext processorContext;

    TracingValueTransformerWithKey(KafkaStreamsTracing kafkaStreamsTracing, String spanName, ValueTransformerWithKey<K, V, VR> delegateTransformer) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracing.tracer();
        this.spanName = spanName;
        this.delegateTransformer = delegateTransformer;
    }

    public void init(ProcessorContext processorContext) {
        this.processorContext = processorContext;
        this.delegateTransformer.init(processorContext);
    }

    public VR transform(K k, V v) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        try {
            Object object;
            block12: {
                Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
                try {
                    Object transform = this.delegateTransformer.transform(k, v);
                    this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.processorContext.headers());
                    object = transform;
                    if (ws == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException e) {
                        span.error(e);
                        throw e;
                    }
                }
                ws.close();
            }
            return (VR)object;
        }
        finally {
            span.finish();
        }
    }

    public void close() {
        this.delegateTransformer.close();
    }
}

