/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class TimeDurationDefinition {
    private Integer years;
    private Integer months;
    private Integer days;
    private Integer hours;
    private Integer minutes;
    private Integer seconds;

    public void setYears(Integer years) {
        this.years = years;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public Integer getYears() {
        return this.years;
    }

    public void setMonths(Integer months) {
        this.months = months;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public Integer getMonths() {
        return this.months;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public Integer getDays() {
        return this.days;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public Integer getHours() {
        return this.hours;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public Integer getMinutes() {
        return this.minutes;
    }

    public void setMinutes(Integer minutes) {
        this.minutes = minutes;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public Integer getSeconds() {
        return this.seconds;
    }

    public void setSeconds(Integer seconds) {
        this.seconds = seconds;
    }

    public String toISO8601DurationString() {
        boolean isTimeDefined;
        StringBuilder builder = new StringBuilder();
        boolean isDateDefined = this.years != null || this.months != null || this.days != null;
        boolean bl = isTimeDefined = this.hours != null || this.minutes != null || this.seconds != null;
        if (isDateDefined || isTimeDefined) {
            builder.append("P");
            if (this.years != null && this.years > 0) {
                builder.append(this.years + "Y");
            }
            if (this.months != null && this.months > 0) {
                builder.append(this.months + "M");
            }
            if (this.days != null && this.days > 0) {
                builder.append(this.days + "D");
            }
            if (isTimeDefined) {
                builder.append("T");
                if (this.hours != null && this.hours > 0) {
                    builder.append(this.hours + "H");
                }
                if (this.minutes != null && this.minutes > 0) {
                    builder.append(this.minutes + "M");
                }
                if (this.seconds != null && this.seconds > 0) {
                    builder.append(this.seconds + "S");
                }
            }
        }
        return builder.toString();
    }
}

