/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io.parsing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.parsing.Symbol;
import org.apache.avro.io.parsing.ValidatingGrammarGenerator;
import org.codehaus.jackson.JsonNode;

public class ResolvingGrammarGenerator
extends ValidatingGrammarGenerator {
    private static EncoderFactory factory = new EncoderFactory().configureBufferSize(32);

    public final Symbol generate(Schema writer, Schema reader) throws IOException {
        return Symbol.root(this.generate(writer, reader, new HashMap<ValidatingGrammarGenerator.LitS, Symbol>()));
    }

    public Symbol generate(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        block36: {
            Schema.Type readerType;
            Schema.Type writerType;
            block35: {
                writerType = writer.getType();
                if (writerType != (readerType = reader.getType())) break block35;
                switch (writerType) {
                    case NULL: {
                        return Symbol.NULL;
                    }
                    case BOOLEAN: {
                        return Symbol.BOOLEAN;
                    }
                    case INT: {
                        return Symbol.INT;
                    }
                    case LONG: {
                        return Symbol.LONG;
                    }
                    case FLOAT: {
                        return Symbol.FLOAT;
                    }
                    case DOUBLE: {
                        return Symbol.DOUBLE;
                    }
                    case STRING: {
                        return Symbol.STRING;
                    }
                    case BYTES: {
                        return Symbol.BYTES;
                    }
                    case FIXED: {
                        if (writer.getFullName().equals(reader.getFullName()) && writer.getFixedSize() == reader.getFixedSize()) {
                            return Symbol.seq(new Symbol.IntCheckAction(writer.getFixedSize()), Symbol.FIXED);
                        }
                        break block36;
                    }
                    case ENUM: {
                        if (writer.getFullName() == null || writer.getFullName().equals(reader.getFullName())) {
                            return Symbol.seq(ResolvingGrammarGenerator.mkEnumAdjust(writer.getEnumSymbols(), reader.getEnumSymbols()), Symbol.ENUM);
                        }
                        break block36;
                    }
                    case ARRAY: {
                        return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, this.generate(writer.getElementType(), reader.getElementType(), seen)), Symbol.ARRAY_START);
                    }
                    case MAP: {
                        return Symbol.seq(Symbol.repeat(Symbol.MAP_END, this.generate(writer.getValueType(), reader.getValueType(), seen), Symbol.STRING), Symbol.MAP_START);
                    }
                    case RECORD: {
                        return this.resolveRecords(writer, reader, seen);
                    }
                    case UNION: {
                        return this.resolveUnion(writer, reader, seen);
                    }
                    default: {
                        throw new AvroTypeException("Unkown type for schema: " + (Object)((Object)writerType));
                    }
                }
            }
            if (writerType == Schema.Type.UNION) {
                return this.resolveUnion(writer, reader, seen);
            }
            switch (readerType) {
                case LONG: {
                    switch (writerType) {
                        case INT: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.LONG);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (writerType) {
                        case INT: 
                        case LONG: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.FLOAT);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (writerType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.DOUBLE);
                        }
                    }
                    break;
                }
                case UNION: {
                    int j = ResolvingGrammarGenerator.bestBranch(reader, writer);
                    if (j < 0) break;
                    Symbol s = this.generate(writer, reader.getTypes().get(j), seen);
                    return Symbol.seq(new Symbol.UnionAdjustAction(j, s), Symbol.UNION);
                }
                case NULL: 
                case BOOLEAN: 
                case INT: 
                case STRING: 
                case BYTES: 
                case ENUM: 
                case ARRAY: 
                case MAP: 
                case RECORD: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected schema type: " + (Object)((Object)readerType));
                }
            }
        }
        return Symbol.error("Found " + writer.getFullName() + ", expecting " + reader.getFullName());
    }

    private Symbol resolveUnion(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        List<Schema> alts = writer.getTypes();
        int size = alts.size();
        Symbol[] symbols = new Symbol[size];
        String[] labels = new String[size];
        int i = 0;
        for (Schema w : alts) {
            symbols[i] = this.generate(w, reader, seen);
            labels[i] = w.getFullName();
            ++i;
        }
        return Symbol.seq(Symbol.alt(symbols, labels), new Symbol.WriterUnionAction());
    }

    private Symbol resolveRecords(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        LitS2 wsc = new LitS2(writer, reader);
        Symbol result = seen.get(wsc);
        if (result == null) {
            String fname;
            List<Schema.Field> wfields = writer.getFields();
            List<Schema.Field> rfields = reader.getFields();
            Schema.Field[] reordered = new Schema.Field[rfields.size()];
            int ridx = 0;
            int count = 1 + wfields.size();
            for (Schema.Field f : wfields) {
                Schema.Field rdrField = reader.getField(f.name());
                if (rdrField == null) continue;
                reordered[ridx++] = rdrField;
            }
            for (Schema.Field rf : rfields) {
                String fname2 = rf.name();
                if (writer.getField(fname2) != null) continue;
                if (rf.defaultValue() == null) {
                    result = Symbol.error("Found " + writer.getFullName() + ", expecting " + reader.getFullName());
                    seen.put(wsc, result);
                    return result;
                }
                reordered[ridx++] = rf;
                count += 3;
            }
            Symbol[] production = new Symbol[count];
            production[--count] = new Symbol.FieldOrderAction(reordered);
            result = Symbol.seq(production);
            seen.put(wsc, result);
            for (Schema.Field wf : wfields) {
                fname = wf.name();
                Schema.Field rf = reader.getField(fname);
                if (rf == null) {
                    production[--count] = new Symbol.SkipAction(this.generate(wf.schema(), wf.schema(), seen));
                    continue;
                }
                production[--count] = this.generate(wf.schema(), rf.schema(), seen);
            }
            for (Schema.Field rf : rfields) {
                fname = rf.name();
                Schema.Field wf = writer.getField(fname);
                if (wf != null) continue;
                byte[] bb = ResolvingGrammarGenerator.getBinary(rf.schema(), rf.defaultValue());
                production[--count] = new Symbol.DefaultStartAction(bb);
                production[--count] = this.generate(rf.schema(), rf.schema(), seen);
                production[--count] = Symbol.DEFAULT_END_ACTION;
            }
        }
        return result;
    }

    private static byte[] getBinary(Schema s, JsonNode n) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder e = factory.binaryEncoder(out, null);
        ResolvingGrammarGenerator.encode(e, s, n);
        e.flush();
        return out.toByteArray();
    }

    public static void encode(Encoder e, Schema s, JsonNode n) throws IOException {
        switch (s.getType()) {
            case RECORD: {
                for (Schema.Field f : s.getFields()) {
                    String name = f.name();
                    JsonNode v = n.get(name);
                    if (v == null) {
                        v = f.defaultValue();
                    }
                    if (v == null) {
                        throw new AvroTypeException("No default value for: " + name);
                    }
                    ResolvingGrammarGenerator.encode(e, f.schema(), v);
                }
                break;
            }
            case ENUM: {
                e.writeEnum(s.getEnumOrdinal(n.getTextValue()));
                break;
            }
            case ARRAY: {
                e.writeArrayStart();
                e.setItemCount(n.size());
                Schema i = s.getElementType();
                for (JsonNode node : n) {
                    e.startItem();
                    ResolvingGrammarGenerator.encode(e, i, node);
                }
                e.writeArrayEnd();
                break;
            }
            case MAP: {
                e.writeMapStart();
                e.setItemCount(n.size());
                Schema v = s.getValueType();
                Iterator it = n.getFieldNames();
                while (it.hasNext()) {
                    e.startItem();
                    String key = (String)it.next();
                    e.writeString(key);
                    ResolvingGrammarGenerator.encode(e, v, n.get(key));
                }
                e.writeMapEnd();
                break;
            }
            case UNION: {
                e.writeIndex(0);
                ResolvingGrammarGenerator.encode(e, s.getTypes().get(0), n);
                break;
            }
            case FIXED: {
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for fixed: " + n);
                }
                byte[] bb = n.getTextValue().getBytes("ISO-8859-1");
                if (bb.length != s.getFixedSize()) {
                    bb = Arrays.copyOf(bb, s.getFixedSize());
                }
                e.writeFixed(bb);
                break;
            }
            case STRING: {
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for string: " + n);
                }
                e.writeString(n.getTextValue());
                break;
            }
            case BYTES: {
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for bytes: " + n);
                }
                e.writeBytes(n.getTextValue().getBytes("ISO-8859-1"));
                break;
            }
            case INT: {
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for int: " + n);
                }
                e.writeInt(n.getIntValue());
                break;
            }
            case LONG: {
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for long: " + n);
                }
                e.writeLong(n.getLongValue());
                break;
            }
            case FLOAT: {
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for float: " + n);
                }
                e.writeFloat((float)n.getDoubleValue());
                break;
            }
            case DOUBLE: {
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for double: " + n);
                }
                e.writeDouble(n.getDoubleValue());
                break;
            }
            case BOOLEAN: {
                if (!n.isBoolean()) {
                    throw new AvroTypeException("Non-boolean default for boolean: " + n);
                }
                e.writeBoolean(n.getBooleanValue());
                break;
            }
            case NULL: {
                if (!n.isNull()) {
                    throw new AvroTypeException("Non-null default value for null type: " + n);
                }
                e.writeNull();
            }
        }
    }

    private static Symbol mkEnumAdjust(List<String> wsymbols, List<String> rsymbols) {
        Object[] adjustments = new Object[wsymbols.size()];
        for (int i = 0; i < adjustments.length; ++i) {
            int j = rsymbols.indexOf(wsymbols.get(i));
            adjustments[i] = j == -1 ? "No match for " + wsymbols.get(i) : new Integer(j);
        }
        return new Symbol.EnumAdjustAction(rsymbols.size(), adjustments);
    }

    private static int bestBranch(Schema r, Schema w) {
        Schema.Type vt = w.getType();
        int j = 0;
        for (Schema b : r.getTypes()) {
            if (vt == b.getType()) {
                if (vt == Schema.Type.RECORD || vt == Schema.Type.ENUM || vt == Schema.Type.FIXED) {
                    String vname = w.getFullName();
                    String bname = b.getFullName();
                    if (vname != null && vname.equals(bname) || vname == bname && vt == Schema.Type.RECORD) {
                        return j;
                    }
                } else {
                    return j;
                }
            }
            ++j;
        }
        j = 0;
        for (Schema b : r.getTypes()) {
            switch (vt) {
                case INT: {
                    switch (b.getType()) {
                        case LONG: 
                        case DOUBLE: {
                            return j;
                        }
                    }
                    break;
                }
                case LONG: 
                case FLOAT: {
                    switch (b.getType()) {
                        case DOUBLE: {
                            return j;
                        }
                    }
                }
            }
            ++j;
        }
        return -1;
    }

    static class LitS2
    extends ValidatingGrammarGenerator.LitS {
        public Schema expected;

        public LitS2(Schema actual, Schema expected) {
            super(actual);
            this.expected = expected;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LitS2)) {
                return false;
            }
            LitS2 other = (LitS2)o;
            return this.actual == other.actual && this.expected == other.expected;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.expected.hashCode();
        }
    }
}

