/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.isis.applib.AbstractViewModel;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.applib.annotation.ViewModelLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.fixtures.FixtureType;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.fixturescripts.ExecutionParameters;
import org.apache.isis.applib.fixturescripts.FixtureResult;
import org.apache.isis.applib.fixturescripts.FixtureResultList;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.fixturescripts.StringUtil;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@ViewModelLayout(named="Script")
public abstract class FixtureScript
extends AbstractViewModel
implements InstallableFixture {
    protected static final String PATH_SEPARATOR = "/";
    private PrintStream tracePrintStream;
    private String friendlyName;
    private String localName;
    private String parentPath;
    private Discoverability discoverability;
    private ExecutionContext executionContext;
    @Inject
    protected FixtureScripts fixtureScripts;
    @Inject
    protected DomainObjectContainer container;
    @Inject
    protected WrapperFactory wrapperFactory;

    public FixtureScript() {
        this(null, null);
    }

    public FixtureScript(String friendlyName, String localName) {
        this(friendlyName, localName, Discoverability.NON_DISCOVERABLE);
    }

    public FixtureScript(String friendlyName, String localName, Discoverability discoverability) {
        this.localName = this.localNameElseDerived(localName);
        this.friendlyName = this.friendlyNameElseDerived(friendlyName);
        this.parentPath = "";
        this.discoverability = discoverability;
        this.withTracing();
    }

    protected String localNameElseDerived(String str) {
        return str != null ? str : StringUtil.asLowerDashed(this.friendlyNameElseDerived(str));
    }

    protected String friendlyNameElseDerived(String str) {
        return str != null ? str : StringUtil.asNaturalName2(this.getClass().getSimpleName());
    }

    @Programmatic
    public FixtureScript withTracing(PrintStream tracePrintStream) {
        this.tracePrintStream = tracePrintStream;
        return this;
    }

    @Programmatic
    public FixtureScript withTracing() {
        return this.withTracing(System.out);
    }

    @Override
    @Programmatic
    public String viewModelMemento() {
        return this.fixtureScripts.mementoFor(this);
    }

    @Override
    @Programmatic
    public void viewModelInit(String mementoStr) {
        this.fixtureScripts.initOf(mementoStr, this);
    }

    @Programmatic
    public String getQualifiedName() {
        return this.getParentPath() + this.getLocalName();
    }

    @Title
    @PropertyLayout(hidden=Where.EVERYWHERE)
    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @PropertyLayout(hidden=Where.EVERYWHERE)
    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Programmatic
    public String getParentPath() {
        return this.parentPath;
    }

    @Programmatic
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @PropertyLayout(hidden=Where.EVERYWHERE)
    public boolean isDiscoverable() {
        return this.discoverability == Discoverability.DISCOVERABLE;
    }

    @Programmatic
    public FixtureScript withDiscoverability(Discoverability discoverability) {
        this.discoverability = discoverability;
        return this;
    }

    protected <T> T defaultParam(String parameterName, ExecutionContext ec, T defaultValue) {
        T value = this.valueFor(parameterName, ec, defaultValue);
        this.setParam(parameterName, value);
        return value;
    }

    private <T> T valueFor(String parameterName, ExecutionContext ec, T defaultValue) {
        Class<?> cls = defaultValue.getClass();
        Object value = this.readParam(parameterName, ec, cls);
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    protected <T> T checkParam(String parameterName, ExecutionContext ec, Class<T> cls) {
        T value = this.readParam(parameterName, ec, cls);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException(String.format("No value for '%s'", parameterName));
    }

    private <T> T readParam(String parameterName, ExecutionContext ec, Class<T> cls) {
        Method method;
        Object value = ec.getParameterAsT(parameterName, cls);
        if (value != null) {
            return value;
        }
        try {
            method = this.getClass().getMethod("get" + this.uppercase(parameterName), new Class[0]);
            value = method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            try {
                method = this.getClass().getMethod("is" + this.uppercase(parameterName), new Class[0]);
                value = method.invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    private <T> void setParam(String parameterName, T value) {
        Method[] methods;
        String mutator = "set" + this.uppercase(parameterName);
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().equals(mutator) || method.getParameterTypes().length != 1) continue;
            try {
                method.invoke((Object)this, value);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
            break;
        }
    }

    private String uppercase(String parameterName) {
        return parameterName.substring(0, 1).toUpperCase() + parameterName.substring(1);
    }

    @Programmatic
    public final List<FixtureResult> run(String parameters) {
        this.executionContext = this.fixtureScripts.newExecutionContext(parameters).withTracing(this.tracePrintStream);
        this.executionContext.executeChildIfNotAlready(this);
        return this.executionContext.getResults();
    }

    @Deprecated
    public <T> T lookup(String key, Class<T> cls) {
        if (this.executionContext == null) {
            throw new IllegalStateException("This fixture has not yet been run.");
        }
        return this.executionContext.lookup(key, cls);
    }

    @Programmatic
    public String validateRun(String parameters) {
        return null;
    }

    @Deprecated
    protected void execute(String localNameOverride, FixtureScript childFixtureScript, ExecutionContext executionContext) {
        executionContext.executeChild(this, localNameOverride, childFixtureScript);
    }

    @Deprecated
    protected void executeChild(String localNameOverride, FixtureScript childFixtureScript, ExecutionContext executionContext) {
        executionContext.executeChild(this, localNameOverride, childFixtureScript);
    }

    @Deprecated
    protected void execute(FixtureScript childFixtureScript, ExecutionContext executionContext) {
        executionContext.executeChild(this, childFixtureScript);
    }

    @Deprecated
    protected void executeChild(FixtureScript childFixtureScript, ExecutionContext executionContext) {
        executionContext.executeChild(this, childFixtureScript);
    }

    @Programmatic
    protected abstract void execute(ExecutionContext var1);

    @Override
    public FixtureType getType() {
        return FixtureType.DOMAIN_OBJECTS;
    }

    @Override
    @Programmatic
    public final void install() {
        this.run(null);
    }

    protected static <T> T coalesce(T ... ts) {
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    protected <T> T wrap(T domainObject) {
        return this.wrapperFactory.wrap(domainObject);
    }

    protected <T> T wrap(T domainObject, WrapperFactory.ExecutionMode executionMode) {
        return this.wrapperFactory.wrap(domainObject, executionMode);
    }

    protected <T> T unwrap(T possibleWrappedDomainObject) {
        return this.wrapperFactory.unwrap(possibleWrappedDomainObject);
    }

    @Programmatic
    String pathWith(String subkey) {
        return (this.getQualifiedName() != null ? this.getQualifiedName() + PATH_SEPARATOR : "") + subkey;
    }

    public static class ExecutionContext {
        public static final ExecutionContext NOOP = new ExecutionContext((String)null, null){

            @Override
            public <T> T add(FixtureScript script, T object) {
                return object;
            }

            @Override
            public <T> T addResult(FixtureScript script, T object) {
                return object;
            }

            @Override
            public <T> T add(FixtureScript script, String key, T object) {
                return object;
            }

            @Override
            public <T> T addResult(FixtureScript script, String key, T object) {
                return object;
            }

            @Override
            public List<FixtureResult> getResults() {
                return Collections.emptyList();
            }
        };
        private final ExecutionParameters executionParameters;
        private final FixtureScripts fixtureScripts;
        private final FixtureResultList fixtureResultList;
        private final Map<String, Class> fixtureScriptClasses = Maps.newLinkedHashMap();
        private int traceHighwatermark = 40;
        private PrintStream tracePrintStream;
        private Map<Class, Object> userData = Maps.newHashMap();

        public ExecutionContext(String parameters, FixtureScripts fixtureScripts) {
            this(new ExecutionParameters(parameters), fixtureScripts);
        }

        @Programmatic
        public static ExecutionContext create(ExecutionParameters executionParameters, FixtureScripts fixtureScripts) {
            return new ExecutionContext(executionParameters, fixtureScripts);
        }

        private ExecutionContext(ExecutionParameters executionParameters, FixtureScripts fixtureScripts) {
            this.fixtureScripts = fixtureScripts;
            this.fixtureResultList = new FixtureResultList(fixtureScripts, this);
            this.executionParameters = executionParameters;
        }

        @Deprecated
        public static Map<String, String> asKeyValueMap(String parameters) {
            return ExecutionParameters.asKeyValueMap(parameters);
        }

        public String getParameters() {
            return this.executionParameters.getParameters();
        }

        public Map<String, String> getParameterMap() {
            return this.executionParameters.getParameterMap();
        }

        public String getParameter(String parameterName) {
            return this.executionParameters.getParameter(parameterName);
        }

        public <T> T getParameterAsT(String parameterName, Class<T> cls) {
            return this.executionParameters.getParameterAsT(parameterName, cls);
        }

        public Boolean getParameterAsBoolean(String parameterName) {
            return this.executionParameters.getParameterAsBoolean(parameterName);
        }

        public Byte getParameterAsByte(String parameterName) {
            return this.executionParameters.getParameterAsByte(parameterName);
        }

        public Short getParameterAsShort(String parameterName) {
            return this.executionParameters.getParameterAsShort(parameterName);
        }

        public Integer getParameterAsInteger(String parameterName) {
            return this.executionParameters.getParameterAsInteger(parameterName);
        }

        public Long getParameterAsLong(String parameterName) {
            return this.executionParameters.getParameterAsLong(parameterName);
        }

        public Float getParameterAsFloat(String parameterName) {
            return this.executionParameters.getParameterAsFloat(parameterName);
        }

        public Double getParameterAsDouble(String parameterName) {
            return this.executionParameters.getParameterAsDouble(parameterName);
        }

        public Character getParameterAsCharacter(String parameterName) {
            return this.executionParameters.getParameterAsCharacter(parameterName);
        }

        public BigInteger getParameterAsBigInteger(String parameterName) {
            return this.executionParameters.getParameterAsBigInteger(parameterName);
        }

        public BigDecimal getParameterAsBigDecimal(String parameterName) {
            return this.executionParameters.getParameterAsBigDecimal(parameterName);
        }

        public LocalDate getParameterAsLocalDate(String parameterName) {
            return this.executionParameters.getParameterAsLocalDate(parameterName);
        }

        public LocalDateTime getParameterAsLocalDateTime(String parameterName) {
            return this.executionParameters.getParameterAsLocalDateTime(parameterName);
        }

        public <T extends Enum<T>> T getParameterAsEnum(String parameterName, Class<T> enumClass) {
            return this.executionParameters.getParameterAsEnum(parameterName, enumClass);
        }

        public void setParameterIfNotPresent(String parameterName, String parameterValue) {
            this.executionParameters.setParameterIfNotPresent(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Boolean parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Byte parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Short parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Integer parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Long parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Float parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Double parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Character parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, BigInteger parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, java.util.Date parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Date parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, LocalDate parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, LocalDateTime parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, DateTime parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, BigDecimal parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, Enum<?> parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public void setParameter(String parameterName, String parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        public List<FixtureResult> getResults() {
            return this.fixtureResultList.getResults();
        }

        @Deprecated
        public <T> T add(FixtureScript script, T object) {
            return this.addResult(script, object);
        }

        public <T> T addResult(FixtureScript script, T object) {
            this.fixtureResultList.add(script, object);
            return object;
        }

        @Deprecated
        public <T> T add(FixtureScript script, String key, T object) {
            return this.addResult(script, key, object);
        }

        public <T> T addResult(FixtureScript script, String key, T object) {
            this.fixtureResultList.add(script, key, object);
            return object;
        }

        public <T> T lookup(String key, Class<T> cls) {
            return this.fixtureResultList.lookup(key, cls);
        }

        public void executeChild(FixtureScript callingFixtureScript, FixtureScript childFixtureScript) {
            this.executeChildT(callingFixtureScript, childFixtureScript);
        }

        public <T extends FixtureScript> T executeChildT(FixtureScript callingFixtureScript, T childFixtureScript) {
            return this.executeChildT(callingFixtureScript, null, childFixtureScript);
        }

        public void executeChild(FixtureScript callingFixtureScript, String localNameOverride, FixtureScript childFixtureScript) {
            this.executeChildT(callingFixtureScript, localNameOverride, childFixtureScript);
        }

        public <T extends FixtureScript> T executeChildT(FixtureScript callingFixtureScript, String localNameOverride, T childFixtureScript) {
            childFixtureScript.setParentPath(callingFixtureScript.pathWith(""));
            childFixtureScript.withTracing(callingFixtureScript.tracePrintStream);
            if (localNameOverride != null) {
                childFixtureScript.setLocalName(localNameOverride);
            }
            callingFixtureScript.getContainer().injectServicesInto(childFixtureScript);
            this.executeChildIfNotAlready(childFixtureScript);
            return childFixtureScript;
        }

        @Deprecated
        public void executeIfNotAlready(FixtureScript fixtureScript) {
            this.executeChildIfNotAlready(fixtureScript);
        }

        private void executeChildIfNotAlready(FixtureScript fixtureScript) {
            if (this.shouldExecute(fixtureScript)) {
                this.trace(fixtureScript, As.EXEC);
                fixtureScript.execute(this);
            } else {
                this.trace(fixtureScript, As.SKIP);
            }
        }

        private boolean shouldExecute(FixtureScript fixtureScript) {
            boolean alreadyExecuted = this.fixtureScriptClasses.values().contains(fixtureScript.getClass());
            if (!alreadyExecuted) {
                this.fixtureScriptClasses.put(fixtureScript.getQualifiedName(), fixtureScript.getClass());
            }
            return !alreadyExecuted || this.fixtureScripts.getMultipleExecutionStrategy().isExecute();
        }

        public ExecutionContext withTracing(PrintStream tracePrintStream) {
            this.tracePrintStream = tracePrintStream;
            return this;
        }

        private void trace(FixtureScript fixtureScript, As as) {
            if (this.tracePrintStream == null) {
                return;
            }
            String qualifiedName = fixtureScript.getQualifiedName();
            String trace = String.format("%1s: %2s %3s\n", new Object[]{this.pad(qualifiedName), as, fixtureScript.getClass().getName()});
            this.tracePrintStream.print(trace);
            this.tracePrintStream.flush();
        }

        void trace(FixtureResult fixtureResult) {
            if (this.tracePrintStream == null) {
                return;
            }
            String key = fixtureResult.getKey();
            String trace = String.format("%1s: %2s\n", this.pad(key), this.fixtureScripts.titleOf(fixtureResult));
            this.tracePrintStream.print(trace);
            this.tracePrintStream.flush();
        }

        private String pad(String key) {
            this.traceHighwatermark = Math.max(key.length(), this.traceHighwatermark);
            return ExecutionContext.pad(key, ExecutionContext.roundup(this.traceHighwatermark, 20));
        }

        private static String pad(String str, int padTo) {
            return Strings.padEnd((String)str, (int)padTo, (char)' ');
        }

        static int roundup(int n, int roundTo) {
            return (n / roundTo + 1) * roundTo;
        }

        public void setUserData(Object object) {
            this.userData.put(object.getClass(), object);
        }

        public <T> T getUserData(Class<T> cls) {
            return (T)this.userData.get(cls);
        }

        public <T> T clearUserData(Class<T> cls) {
            return (T)this.userData.remove(cls);
        }

        static enum As {
            EXEC,
            SKIP;

        }
    }

    public static enum Discoverability {
        DISCOVERABLE,
        NON_DISCOVERABLE;

    }
}

