/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.Command3;
import org.apache.isis.applib.services.eventbus.ActionDomainEvent;
import org.apache.isis.applib.services.eventbus.ActionInteractionEvent;
import org.apache.isis.applib.util.ObjectContracts;

public class CommandDefault
implements Command3 {
    private String actionIdentifier;
    private String targetClass;
    private String targetAction;
    private String arguments;
    private String memento;
    private Bookmark target;
    private Timestamp timestamp;
    private Timestamp startedAt;
    private Timestamp completedAt;
    private String user;
    private final LinkedList<ActionDomainEvent<?>> actionDomainEvents = Lists.newLinkedList();
    private Command.Executor executor;
    private Command.ExecuteIn executionType;
    private Command parent;
    private Bookmark result;
    private String exceptionStackTrace;
    private UUID transactionId;
    private Command.Persistence persistence;
    private boolean persistHint;
    private final Map<String, AtomicInteger> sequenceByName = Maps.newHashMap();

    public CommandDefault() {
        this.setExecutor(Command.Executor.OTHER);
    }

    @Override
    public String getMemberIdentifier() {
        return this.actionIdentifier;
    }

    @Override
    public void setMemberIdentifier(String actionIdentifier) {
        this.actionIdentifier = actionIdentifier;
    }

    @Override
    public String getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public String getTargetAction() {
        return this.targetAction;
    }

    @Override
    public void setTargetAction(String targetAction) {
        this.targetAction = targetAction;
    }

    @Override
    public String getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    @Override
    public String getMemento() {
        return this.memento;
    }

    @Override
    public void setMemento(String memento) {
        this.memento = memento;
    }

    @Override
    public Bookmark getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Bookmark target) {
        this.target = target;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Timestamp startedAt) {
        this.timestamp = startedAt;
    }

    @Override
    public Timestamp getStartedAt() {
        return this.startedAt;
    }

    @Override
    public void setStartedAt(Timestamp startedAt) {
        this.startedAt = startedAt;
    }

    @Override
    public Timestamp getCompletedAt() {
        return this.completedAt;
    }

    @Override
    public void setCompletedAt(Timestamp completed) {
        this.completedAt = completed;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    @Deprecated
    public ActionInteractionEvent<?> peekActionInteractionEvent() {
        ActionDomainEvent<?> actionDomainEvent = this.peekActionDomainEvent();
        if (actionDomainEvent != null && !(actionDomainEvent instanceof ActionInteractionEvent)) {
            throw new IllegalStateException("Most recently pushed event was not an instance of ActionInteractionEvent; use either ActionDomainEvent or the (deprecated) ActionInteractionEvent consistently");
        }
        return (ActionInteractionEvent)actionDomainEvent;
    }

    @Override
    @Deprecated
    public void pushActionInteractionEvent(ActionInteractionEvent<?> event) {
        this.pushActionDomainEvent(event);
    }

    @Deprecated
    public ActionInteractionEvent popActionInteractionEvent() {
        ActionDomainEvent actionDomainEvent = this.popActionDomainEvent();
        if (actionDomainEvent != null && !(actionDomainEvent instanceof ActionInteractionEvent)) {
            throw new IllegalStateException("Most recently pushed event was not an instance of ActionInteractionEvent; use either ActionDomainEvent or the (deprecated) ActionInteractionEvent consistently");
        }
        return (ActionInteractionEvent)actionDomainEvent;
    }

    @Override
    @Deprecated
    @Programmatic
    public List<ActionInteractionEvent<?>> flushActionInteractionEvents() {
        List<ActionDomainEvent<?>> actionDomainEvents = this.flushActionDomainEvents();
        for (ActionDomainEvent<?> actionDomainEvent : actionDomainEvents) {
            if (actionDomainEvent instanceof ActionInteractionEvent) continue;
            throw new IllegalStateException("List of events includes at least one event that is not an instance of ActionInteractionEvent; use either ActionDomainEvent or the (deprecated) ActionInteractionEvent consistently");
        }
        return actionDomainEvents;
    }

    @Override
    public ActionDomainEvent<?> peekActionDomainEvent() {
        return this.actionDomainEvents.isEmpty() ? null : this.actionDomainEvents.getLast();
    }

    @Override
    public void pushActionDomainEvent(ActionDomainEvent<?> event) {
        if (this.peekActionDomainEvent() == event) {
            return;
        }
        this.actionDomainEvents.add(event);
    }

    public ActionDomainEvent popActionDomainEvent() {
        return !this.actionDomainEvents.isEmpty() ? this.actionDomainEvents.removeLast() : null;
    }

    @Override
    @Programmatic
    public List<ActionDomainEvent<?>> flushActionDomainEvents() {
        List<ActionDomainEvent<?>> events = Collections.unmodifiableList(Lists.newArrayList(this.actionDomainEvents));
        this.actionDomainEvents.clear();
        return events;
    }

    @Override
    public Command.Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Command.Executor nature) {
        this.executor = nature;
    }

    @Override
    public Command.ExecuteIn getExecuteIn() {
        return this.executionType;
    }

    @Override
    public void setExecuteIn(Command.ExecuteIn executionType) {
        this.executionType = executionType;
    }

    @Override
    public Command getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Command parent) {
        this.parent = parent;
    }

    @Override
    public Bookmark getResult() {
        return this.result;
    }

    @Override
    public void setResult(Bookmark result) {
        this.result = result;
    }

    @Override
    public String getException() {
        return this.exceptionStackTrace;
    }

    @Override
    public void setException(String exceptionStackTrace) {
        this.exceptionStackTrace = exceptionStackTrace;
    }

    @Override
    public UUID getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void setTransactionId(UUID transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public Command.Persistence getPersistence() {
        return this.persistence;
    }

    @Override
    public void setPersistence(Command.Persistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public boolean isPersistHint() {
        return this.persistHint;
    }

    @Override
    public void setPersistHint(boolean persistHint) {
        this.persistHint = persistHint;
    }

    @Override
    public int next(String sequenceName) {
        AtomicInteger next = this.sequenceByName.get(sequenceName);
        if (next == null) {
            next = new AtomicInteger(0);
            this.sequenceByName.put(sequenceName, next);
        } else {
            next.incrementAndGet();
        }
        return next.get();
    }

    public String toString() {
        return ObjectContracts.toString((Object)this, "startedAt,user,memberIdentifier,target,transactionId");
    }
}

