/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.eventbus;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.util.ObjectContracts;

public abstract class AbstractDomainEvent<S>
extends EventObject {
    private static final long serialVersionUID = 1L;
    private Phase phase;
    private final Identifier identifier;
    private boolean hidden;
    private String disabledReason;
    private TranslatableString disabledReasonTranslatable;
    private String invalidatedReason;
    private TranslatableString invalidatedReasonTranslatable;
    private final Map<Object, Object> userData = Maps.newHashMap();

    public AbstractDomainEvent(S source, Identifier identifier) {
        super(source);
        this.identifier = identifier;
    }

    public Phase getEventPhase() {
        return this.phase;
    }

    public void setEventPhase(Phase phase) {
        this.phase = phase;
    }

    public S getSource() {
        return (S)this.source;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void hide() {
        this.hidden = true;
    }

    public boolean isDisabled() {
        return this.disabledReason != null || this.disabledReasonTranslatable != null;
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public void disable(String reason) {
        this.disabledReason = reason;
    }

    public TranslatableString getDisabledReasonTranslatable() {
        return this.disabledReasonTranslatable;
    }

    public void disable(TranslatableString reason) {
        this.disabledReasonTranslatable = reason;
    }

    public boolean isInvalid() {
        return this.invalidatedReason != null || this.invalidatedReasonTranslatable != null;
    }

    public String getInvalidityReason() {
        return this.invalidatedReason;
    }

    public void invalidate(String reason) {
        this.invalidatedReason = reason;
    }

    public TranslatableString getInvalidityReasonTranslatable() {
        return this.invalidatedReasonTranslatable;
    }

    public void invalidate(TranslatableString reason) {
        this.invalidatedReasonTranslatable = reason;
    }

    @Programmatic
    public void veto(String reason, Object ... args) {
        switch (this.getEventPhase()) {
            case HIDE: {
                this.hide();
            }
            case DISABLE: {
                this.disable(String.format(reason, args));
            }
            case VALIDATE: {
                this.invalidate(String.format(reason, args));
            }
        }
    }

    @Programmatic
    public void veto(TranslatableString translatableReason) {
        switch (this.getEventPhase()) {
            case HIDE: {
                this.hide();
            }
            case DISABLE: {
                this.disable(translatableReason);
            }
            case VALIDATE: {
                this.invalidate(translatableReason);
            }
        }
    }

    public Object get(Object key) {
        return this.userData.get(key);
    }

    public void put(Object key, Object value) {
        this.userData.put(key, value);
    }

    @Override
    public String toString() {
        return ObjectContracts.toString((Object)this, "source,identifier,mode");
    }

    public static enum Phase {
        HIDE,
        DISABLE,
        VALIDATE,
        EXECUTING,
        EXECUTED;


        public boolean isValidatingOrLater() {
            return this == VALIDATE || this.isExecutingOrLater();
        }

        public boolean isExecutingOrLater() {
            return this.isExecuting() || this.isExecuted();
        }

        public boolean isExecuting() {
            return this == EXECUTING;
        }

        public boolean isExecuted() {
            return this == EXECUTED;
        }
    }
}

