/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.applib.service.exceprecog;

import com.google.common.base.Strings;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.objectstore.jdo.applib.service.exceprecog.ExceptionRecognizerForJDODataStoreException;
import org.apache.isis.objectstore.jdo.applib.service.exceprecog.ExceptionRecognizerForJDODataStoreExceptionIntegrityConstraintViolationForeignKeyNoActionException;
import org.apache.isis.objectstore.jdo.applib.service.exceprecog.ExceptionRecognizerForJDOObjectNotFoundException;
import org.apache.isis.objectstore.jdo.applib.service.exceprecog.ExceptionRecognizerForSQLIntegrityConstraintViolationUniqueOrIndexException;

@DomainService(nature=NatureOfService.DOMAIN)
public class ExceptionRecognizerCompositeForJdoObjectStore
extends ExceptionRecognizerComposite {
    public static final String KEY_DISABLE = "isis.services.ExceptionRecognizerCompositeForJdoObjectStore.disable";

    public ExceptionRecognizerCompositeForJdoObjectStore() {
        super(new ExceptionRecognizer[0]);
    }

    @Override
    @Programmatic
    @PostConstruct
    public void init(Map<String, String> properties) {
        boolean disabled = ExceptionRecognizerCompositeForJdoObjectStore.getElseFalse(properties, KEY_DISABLE);
        if (disabled) {
            return;
        }
        this.addChildren();
        super.init(properties);
    }

    private static boolean getElseFalse(Map<String, String> properties, String key) {
        String value = properties.get(key);
        return !Strings.isNullOrEmpty((String)value) && Boolean.parseBoolean(value);
    }

    protected void addChildren() {
        this.add(new ExceptionRecognizerForSQLIntegrityConstraintViolationUniqueOrIndexException());
        this.add(new ExceptionRecognizerForJDODataStoreExceptionIntegrityConstraintViolationForeignKeyNoActionException());
        this.add(new ExceptionRecognizerForJDOObjectNotFoundException());
        this.add(new ExceptionRecognizerForJDODataStoreException());
    }
}

