/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.integtestsupport.scenarios;

import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.integtestsupport.IsisSystemForTest;
import org.apache.isis.core.specsupport.scenarios.DomainServiceProvider;
import org.apache.isis.core.specsupport.scenarios.ScenarioExecution;
import org.apache.isis.core.specsupport.scenarios.ScenarioExecutionScope;

public class ScenarioExecutionForIntegration
extends ScenarioExecution {
    private IsisSystemForTest isft;

    public ScenarioExecutionForIntegration() {
        super((DomainServiceProvider)IsisSystemForTest.get(), ScenarioExecutionScope.INTEGRATION);
        this.isft = (IsisSystemForTest)this.dsp;
    }

    public WrapperFactory wrapperFactory() {
        return (WrapperFactory)this.service(WrapperFactory.class);
    }

    public void install(InstallableFixture ... fixtures) {
        this.isft.installFixtures(fixtures);
    }

    public void beginTran() {
        this.isft.beginTran();
    }

    public void endTran(boolean ok) {
        if (ok) {
            this.isft.commitTran();
        } else {
            this.isft.abortTran();
        }
    }

    public void openSession() {
        try {
            this.isft.openSession();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void openSession(AuthenticationSession authenticationSession) {
        try {
            this.isft.openSession(authenticationSession);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void closeSession() {
        try {
            this.isft.closeSession();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

