/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ExceptionUtils {
    private static String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;
    private static final Method THROWABLE_INITCAUSE_METHOD;
    private static final Object[] EMPTY_OBJECT_ARRAY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable getCause(Throwable throwable) {
        String[] stringArray = CAUSE_METHOD_NAMES;
        synchronized (CAUSE_METHOD_NAMES) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        String methodName;
        if (throwable == null) {
            return null;
        }
        Throwable cause = ExceptionUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause != null) return cause;
        if (methodNames == null) {
            String[] stringArray = CAUSE_METHOD_NAMES;
            // MONITORENTER : CAUSE_METHOD_NAMES
            methodNames = CAUSE_METHOD_NAMES;
            // MONITOREXIT : stringArray
        }
        for (int i = 0; i < methodNames.length && ((methodName = methodNames[i]) == null || (cause = ExceptionUtils.getCauseUsingMethodName(throwable, methodName)) == null); ++i) {
        }
        if (cause != null) return cause;
        return ExceptionUtils.getCauseUsingFieldName(throwable, "detail");
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        if (ExceptionUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        String[] stringArray = CAUSE_METHOD_NAMES;
        synchronized (CAUSE_METHOD_NAMES) {
            int isize = CAUSE_METHOD_NAMES.length;
            for (int i = 0; i < isize; ++i) {
                try {
                    Method method = cls.getMethod(CAUSE_METHOD_NAMES[i], null);
                    if (method == null || !Throwable.class.isAssignableFrom(method.getReturnType())) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                Field field = cls.getField("detail");
                if (field != null) {
                    return true;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return false;
        }
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        List list = ExceptionUtils.getThrowableList(throwable);
        return list.toArray(new Throwable[list.size()]);
    }

    public static List getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return list;
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = ExceptionUtils.getThrowables(throwable);
        for (int i = 0; i < ts.length; ++i) {
            ts[i].printStackTrace(pw);
            if (ExceptionUtils.isNestedThrowable(ts[i])) break;
        }
        return sw.getBuffer().toString();
    }

    static {
        Method causeMethod;
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            causeMethod = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception e) {
            causeMethod = null;
        }
        THROWABLE_CAUSE_METHOD = causeMethod;
        try {
            causeMethod = Throwable.class.getMethod("initCause", Throwable.class);
        }
        catch (Exception e) {
            causeMethod = null;
        }
        THROWABLE_INITCAUSE_METHOD = causeMethod;
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

