/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.commons.lang.ClassExtensions;

public final class ObjectExtensions {
    private ObjectExtensions() {
    }

    public static <T> T asT(Object extendee) {
        return (T)extendee;
    }

    public static <T> Enumeration<T> asEnumerationT(Object extendee, Class<T> castTo) {
        return (Enumeration)extendee;
    }

    public static <T> Iterator<T> asIteratorT(Object extendee, Class<T> castTo) {
        return (Iterator)extendee;
    }

    public static <T> Collection<T> asCollectionT(Object extendee, Class<T> castTo) {
        return (Collection)extendee;
    }

    public static <T> List<T> asListT(Object extendee, Class<T> castTo) {
        return (List)extendee;
    }

    public static <T> Vector<T> asVectorT(Object extendee, Class<T> castTo) {
        return (Vector)extendee;
    }

    public static <T> Set<T> asSetT(Object extendee, Class<T> castTo) {
        return (Set)extendee;
    }

    public static <T> SortedSet<T> asSortedSetT(Object extendee, Class<T> castTo) {
        return (SortedSet)extendee;
    }

    public static <K, V> Map<K, V> asMapKV(Object extendee, Class<K> keyCastTo, Class<V> valueCastTo) {
        return (Map)extendee;
    }

    public static <K, V> SortedMap<K, V> asSortedMapKV(Object extendee, Class<K> keyCastTo, Class<V> valueCastTo) {
        return (SortedMap)extendee;
    }

    public static Object[] asArray(Object extendee) {
        Class<?> arrayType = extendee.getClass().getComponentType();
        if (!arrayType.isPrimitive()) {
            return (Object[])extendee;
        }
        if (arrayType == Character.TYPE) {
            return ArrayExtensions.asCharToCharacterArray(extendee);
        }
        return ArrayExtensions.convertPrimitiveToObjectArray(extendee, arrayType);
    }

    public static Method getMethod(Object object, String methodName, Class<?> ... parameterClass) throws NoSuchMethodException {
        return ClassExtensions.getMethod(object.getClass(), methodName, parameterClass);
    }

    public static Method getMethod(Object object, String methodName) throws NoSuchMethodException {
        return ClassExtensions.getMethod(object.getClass(), methodName, new Class[0]);
    }

    public static String classBaseName(Object forObject) {
        String name = forObject.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static void appendToString(Object extendee, Appendable buf) {
        try {
            buf.append(ObjectExtensions.classBaseName(extendee));
            buf.append('@');
            buf.append(Integer.toHexString(extendee.hashCode()));
        }
        catch (IOException iox) {
            throw new RuntimeException("A problem occurred while appending an object to an appendable", iox);
        }
    }
}

