/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.io.InputStream;
import java.net.URL;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static URL getResourceURL(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(resource);
        if (url != null) {
            return url;
        }
        classLoader = ResourceUtil.class.getClassLoader();
        url = classLoader.getResource(resource);
        if (url != null) {
            return url;
        }
        try {
            return ClassLoader.getSystemResource(resource);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream(resource);
        if (is != null) {
            return is;
        }
        classLoader = ResourceUtil.class.getClassLoader();
        is = classLoader.getResourceAsStream(resource);
        if (is != null) {
            return is;
        }
        try {
            return ClassLoader.getSystemResourceAsStream(resource);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }
}

