/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.mgr;

import java.util.concurrent.Callable;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.core.commons.components.Injectable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public interface AdapterManager
extends Injectable {
    public ObjectAdapter getAdapterFor(Oid var1);

    public ObjectAdapter getAdapterFor(Object var1);

    public ObjectAdapter adapterFor(TypedOid var1);

    public ObjectAdapter adapterFor(TypedOid var1, ConcurrencyChecking var2);

    public ObjectAdapter adapterFor(Object var1);

    public ObjectAdapter adapterFor(Object var1, ObjectAdapter var2);

    public ObjectAdapter adapterFor(Object var1, ObjectAdapter var2, OneToManyAssociation var3);

    public ObjectAdapter mapRecreatedPojo(Oid var1, Object var2);

    public void removeAdapter(ObjectAdapter var1);

    public static enum ConcurrencyChecking {
        NO_CHECK,
        CHECK;

        private static ThreadLocal<ConcurrencyChecking> concurrencyChecking;

        public boolean isChecking() {
            return this == CHECK;
        }

        public static ConcurrencyChecking concurrencyCheckingFor(ActionSemantics.Of actionSemantics) {
            return actionSemantics.isSafeInNature() ? NO_CHECK : CHECK;
        }

        public static boolean isCurrentlyEnabled() {
            return concurrencyChecking.get().isChecking();
        }

        public static <T> T executeWithConcurrencyCheckingDisabled(Callable<T> callable) {
            ConcurrencyChecking prior = concurrencyChecking.get();
            try {
                concurrencyChecking.set(NO_CHECK);
                T t = callable.call();
                return t;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                concurrencyChecking.set(prior);
            }
        }

        public static void executeWithConcurrencyCheckingDisabled(Runnable runnable) {
            ConcurrencyChecking prior = concurrencyChecking.get();
            try {
                concurrencyChecking.set(NO_CHECK);
                runnable.run();
            }
            finally {
                concurrencyChecking.set(prior);
            }
        }

        static {
            concurrencyChecking = new ThreadLocal<ConcurrencyChecking>(){

                @Override
                protected ConcurrencyChecking initialValue() {
                    return CHECK;
                }
            };
        }
    }
}

