/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public final class CollectionOid
extends ParentedOid
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private int cachedHashCode;

    public CollectionOid(TypedOid parentOid, OneToManyAssociation otma) {
        this(parentOid, otma.getId());
    }

    public CollectionOid(TypedOid parentOid, String name) {
        super(parentOid);
        this.name = name;
        this.cacheState();
    }

    public static CollectionOid deString(String oidStr, OidMarshaller oidMarshaller) {
        return oidMarshaller.unmarshal(oidStr, CollectionOid.class);
    }

    @Override
    public String enString(OidMarshaller oidMarshaller) {
        return oidMarshaller.marshal(this);
    }

    @Override
    public String enStringNoVersion(OidMarshaller oidMarshaller) {
        return oidMarshaller.marshalNoVersion(this);
    }

    public CollectionOid(DataInputExtended inputStream) throws IOException {
        this(CollectionOid.deString(inputStream.readUTF(), CollectionOid.getEncodingMarshaller()));
    }

    private CollectionOid(CollectionOid oid) throws IOException {
        super(oid.getParentOid());
        this.name = oid.name;
    }

    @Override
    public void encode(DataOutputExtended outputStream) throws IOException {
        outputStream.writeUTF(this.enString(CollectionOid.getEncodingMarshaller()));
    }

    private static OidMarshaller getEncodingMarshaller() {
        return new OidMarshaller();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((CollectionOid)other);
    }

    public boolean equals(CollectionOid other) {
        return Objects.equal((Object)other.getParentOid(), (Object)this.getParentOid()) && Objects.equal((Object)other.name, (Object)this.name);
    }

    public int hashCode() {
        this.cacheState();
        return this.cachedHashCode;
    }

    private void cacheState() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.getParentOid().hashCode();
        this.cachedHashCode = hashCode = 37 * hashCode + this.name.hashCode();
    }

    public CollectionOid asPersistent(TypedOid newParentRootOid) {
        return new CollectionOid(newParentRootOid, this.name);
    }
}

