/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class OidMatchers {
    private OidMatchers() {
    }

    public static Matcher<Oid> matching(final String objectType, final String identifier) {
        return new TypeSafeMatcher<Oid>(){

            public void describeTo(Description arg0) {
                arg0.appendText("matching [" + objectType + ", " + identifier + "]");
            }

            public boolean matchesSafely(Oid oid) {
                if (oid instanceof RootOid) {
                    RootOid rootOid = (RootOid)oid;
                    return rootOid.getObjectSpecId().equals(objectType) && rootOid.getIdentifier().equals(identifier);
                }
                return false;
            }
        };
    }
}

