/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.matchers.IsisMatchers;
import org.apache.isis.core.commons.url.UrlEncodingUtils;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RootOidDefault
implements Serializable,
RootOid {
    private static final Logger LOG = LoggerFactory.getLogger(RootOidDefault.class);
    private static final long serialVersionUID = 1L;
    private final ObjectSpecId objectSpecId;
    private final String identifier;
    private final Oid.State state;
    private Version version;
    private int cachedHashCode;

    public static RootOidDefault createTransient(ObjectSpecId objectSpecId, String identifier) {
        return new RootOidDefault(objectSpecId, identifier, Oid.State.TRANSIENT);
    }

    public static RootOid create(Bookmark bookmark) {
        return new RootOidDefault(ObjectSpecId.of(bookmark.getObjectType()), bookmark.getIdentifier(), Oid.State.from(bookmark));
    }

    public static RootOidDefault create(ObjectSpecId objectSpecId, String identifier) {
        return RootOidDefault.create(objectSpecId, identifier, null);
    }

    public static RootOidDefault create(ObjectSpecId objectSpecId, String identifier, Long versionSequence) {
        return RootOidDefault.create(objectSpecId, identifier, versionSequence, null, null);
    }

    public static RootOidDefault create(ObjectSpecId objectSpecId, String identifier, Long versionSequence, String versionUser) {
        return RootOidDefault.create(objectSpecId, identifier, versionSequence, versionUser, null);
    }

    public static RootOidDefault create(ObjectSpecId objectSpecId, String identifier, Long versionSequence, Long versionUtcTimestamp) {
        return RootOidDefault.create(objectSpecId, identifier, versionSequence, null, versionUtcTimestamp);
    }

    public static RootOidDefault create(ObjectSpecId objectSpecId, String identifier, Long versionSequence, String versionUser, Long versionUtcTimestamp) {
        return new RootOidDefault(objectSpecId, identifier, Oid.State.PERSISTENT, Version.create(versionSequence, versionUser, versionUtcTimestamp));
    }

    public RootOidDefault(ObjectSpecId objectSpecId, String identifier, Oid.State state) {
        this(objectSpecId, identifier, state, (Version)null);
    }

    public RootOidDefault(ObjectSpecId objectSpecId, String identifier, Oid.State state, Long versionSequence) {
        this(objectSpecId, identifier, state, versionSequence, null, null);
    }

    public RootOidDefault(ObjectSpecId objectSpecId, String identifier, Oid.State state, Long versionSequence, String versionUser) {
        this(objectSpecId, identifier, state, versionSequence, versionUser, null);
    }

    public RootOidDefault(ObjectSpecId objectSpecId, String identifier, Oid.State state, Long versionSequence, Long versionUtcTimestamp) {
        this(objectSpecId, identifier, state, versionSequence, null, versionUtcTimestamp);
    }

    public RootOidDefault(ObjectSpecId objectSpecId, String identifier, Oid.State state, Long versionSequence, String versionUser, Long versionUtcTimestamp) {
        this(objectSpecId, identifier, state, Version.create(versionSequence, versionUser, versionUtcTimestamp));
    }

    public RootOidDefault(ObjectSpecId objectSpecId, String identifier, Oid.State state, Version version) {
        Ensure.ensureThatArg(objectSpecId, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(identifier, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(identifier, CoreMatchers.is((Matcher)CoreMatchers.not(IsisMatchers.contains("#"))), "identifier '" + identifier + "' contains a '#' symbol");
        Ensure.ensureThatArg(identifier, CoreMatchers.is((Matcher)CoreMatchers.not(IsisMatchers.contains("@"))), "identifier '" + identifier + "' contains an '@' symbol");
        Ensure.ensureThatArg(state, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.objectSpecId = objectSpecId;
        this.identifier = identifier;
        this.state = state;
        this.version = version;
        this.initialized();
    }

    private void initialized() {
        this.cacheState();
    }

    public RootOidDefault(DataInputExtended input) throws IOException {
        String oidStr = input.readUTF();
        RootOidDefault oid = this.getEncodingMarshaller().unmarshal(oidStr, RootOidDefault.class);
        this.objectSpecId = oid.objectSpecId;
        this.identifier = oid.identifier;
        this.state = oid.state;
        this.version = oid.version;
        this.cacheState();
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.enString(this.getEncodingMarshaller()));
    }

    private OidMarshaller getEncodingMarshaller() {
        return new OidMarshaller();
    }

    public static RootOid deStringEncoded(String urlEncodedOidStr, OidMarshaller oidMarshaller) {
        String oidStr = UrlEncodingUtils.urlDecode(urlEncodedOidStr);
        return RootOidDefault.deString(oidStr, oidMarshaller);
    }

    public static RootOidDefault deString(String oidStr, OidMarshaller oidMarshaller) {
        return oidMarshaller.unmarshal(oidStr, RootOidDefault.class);
    }

    @Override
    public String enString(OidMarshaller oidMarshaller) {
        return oidMarshaller.marshal(this);
    }

    @Override
    public String enStringNoVersion(OidMarshaller oidMarshaller) {
        return oidMarshaller.marshalNoVersion(this);
    }

    @Override
    public ObjectSpecId getObjectSpecId() {
        return this.objectSpecId;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isTransient() {
        return this.state.isTransient();
    }

    @Override
    public boolean isViewModel() {
        return this.state.isViewModel();
    }

    @Override
    public boolean isPersistent() {
        return this.state.isPersistent();
    }

    @Override
    public RootOidDefault asPersistent(String identifier) {
        Ensure.ensureThatState(this.state.isTransient(), CoreMatchers.is((Object)true));
        Ensure.ensureThatArg(identifier, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        return new RootOidDefault(this.objectSpecId, identifier, Oid.State.PERSISTENT);
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public RootOid.Comparison compareAgainst(RootOid other) {
        if (!this.equals(other)) {
            return RootOid.Comparison.NOT_EQUIVALENT;
        }
        if (this.getVersion() == null || other.getVersion() == null) {
            return RootOid.Comparison.EQUIVALENT_BUT_NO_VERSION_INFO;
        }
        return this.getVersion().equals(other.getVersion()) ? RootOid.Comparison.EQUIVALENT_AND_UNCHANGED : RootOid.Comparison.EQUIVALENT_BUT_CHANGED;
    }

    @Override
    public Bookmark asBookmark() {
        String objectType = this.state.asBookmarkObjectState().getCode() + this.getObjectSpecId().asString();
        String identifier = this.getIdentifier();
        return new Bookmark(objectType, identifier);
    }

    private void cacheState() {
        this.cachedHashCode = 17;
        this.cachedHashCode = 37 * this.cachedHashCode + this.objectSpecId.hashCode();
        this.cachedHashCode = 37 * this.cachedHashCode + this.identifier.hashCode();
        this.cachedHashCode = 37 * this.cachedHashCode + (this.isTransient() ? 0 : 1);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((RootOid)other);
    }

    public boolean equals(RootOid other) {
        return Objects.equal((Object)this.objectSpecId, (Object)other.getObjectSpecId()) && Objects.equal((Object)this.identifier, (Object)other.getIdentifier()) && Objects.equal((Object)this.isTransient(), (Object)other.isTransient());
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        return this.enString(new OidMarshaller());
    }
}

