/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.version;

import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.version.Version;

public class ConcurrencyException
extends IsisException {
    private static final long serialVersionUID = 1L;
    private final Oid oid;

    private static String buildMessage(String currentUser, Oid oid, Version staleVersion, Version datastoreVersion) {
        StringBuilder buf = new StringBuilder();
        buf.append(currentUser != null ? currentUser + " " : "");
        buf.append(" attempted to update ").append(oid.enStringNoVersion(ConcurrencyException.getOidMarshaller()));
        buf.append(", however this object has since been modified");
        if (datastoreVersion.getUser() != null) {
            buf.append(" by ").append(datastoreVersion.getUser());
        }
        if (datastoreVersion.getTime() != null) {
            buf.append(" at ").append(datastoreVersion.getTime());
        }
        buf.append(" [").append(staleVersion.getSequence()).append(" vs ").append(datastoreVersion.getSequence()).append("]");
        return buf.toString();
    }

    public ConcurrencyException(String currentUser, Oid oid, Version staleVersion, Version datastoreVersion) {
        this(ConcurrencyException.buildMessage(currentUser, oid, staleVersion, datastoreVersion), oid);
    }

    public ConcurrencyException(String message, Oid oid) {
        super(message);
        this.oid = oid;
    }

    public Oid getOid() {
        return this.oid;
    }

    private static OidMarshaller getOidMarshaller() {
        return new OidMarshaller();
    }
}

