/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facetapi;

import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.matchers.IsisMatchers;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class FacetAbstract
implements Facet {
    private Facet underlyingFacet;
    private final Class<? extends Facet> facetType;
    private final boolean derived;
    private FacetHolder holder;
    private IdentifiedHolder identifiedHolder;

    public FacetAbstract(Class<? extends Facet> facetType, FacetHolder holder, Derivation derivation) {
        this.facetType = Ensure.ensureThatArg(facetType, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue(Class.class))));
        this.setFacetHolder(Ensure.ensureThatArg(holder, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue(FacetHolder.class)))));
        this.derived = derivation == Derivation.DERIVED;
    }

    @Override
    public final Class<? extends Facet> facetType() {
        return this.facetType;
    }

    @Override
    public FacetHolder getFacetHolder() {
        return this.holder;
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    public IdentifiedHolder getIdentified() {
        return this.identifiedHolder;
    }

    @Override
    public Facet getUnderlyingFacet() {
        return this.underlyingFacet;
    }

    @Override
    public void setUnderlyingFacet(Facet underlyingFacet) {
        if (underlyingFacet != null) {
            if (underlyingFacet instanceof MultiTypedFacet) {
                MultiTypedFacet multiTypedFacet = (MultiTypedFacet)underlyingFacet;
                boolean matches = this.compatible(multiTypedFacet);
                if (!matches) {
                    throw new IllegalArgumentException("illegal argument, expected underlying facet (a multi-valued facet) to have equivalent to the facet type (or facet types) of this facet");
                }
            } else {
                Ensure.ensureThatArg(underlyingFacet.facetType(), IsisMatchers.classEqualTo(this.facetType));
            }
        }
        this.underlyingFacet = underlyingFacet;
    }

    private boolean compatible(MultiTypedFacet multiTypedFacet) {
        Class<? extends Facet>[] facetTypes;
        if (!(this instanceof MultiTypedFacet)) {
            return multiTypedFacet.containsFacetTypeOf(this.facetType);
        }
        MultiTypedFacet thisAsMultiTyped = (MultiTypedFacet)((Object)this);
        for (Class<? extends Facet> facetType : facetTypes = thisAsMultiTyped.facetTypes()) {
            if (!multiTypedFacet.containsFacetTypeOf(facetType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    @Override
    public boolean alwaysReplace() {
        return true;
    }

    @Override
    public void setFacetHolder(FacetHolder facetHolder) {
        this.holder = facetHolder;
        this.identifiedHolder = this.holder instanceof IdentifiedHolder ? (IdentifiedHolder)this.holder : null;
    }

    protected String toStringValues() {
        return "";
    }

    public String toString() {
        String details = "";
        if (Validating.class.isAssignableFrom(this.getClass())) {
            details = details + "Validating";
        }
        if (Disabling.class.isAssignableFrom(this.getClass())) {
            details = details + (details.length() > 0 ? ";" : "") + "Disabling";
        }
        if (Hiding.class.isAssignableFrom(this.getClass())) {
            details = details + (details.length() > 0 ? ";" : "") + "Hiding";
        }
        if (!"".equals(details)) {
            details = "interaction=" + details + ",";
        }
        String className = this.getClass().getName();
        String stringValues = this.toStringValues();
        if (this.getClass() != this.facetType()) {
            String facetType = this.facetType().getName();
            details = details + "type=" + facetType.substring(facetType.lastIndexOf(46) + 1);
        }
        if (!"".equals(stringValues)) {
            details = details + ",";
        }
        return className.substring(className.lastIndexOf(46) + 1) + "[" + details + stringValues + "]";
    }

    public static interface Validating {
    }

    public static interface Disabling {
    }

    public static interface Hiding {
    }

    public static enum Derivation {
        DERIVED,
        NOT_DERIVED;

    }
}

