/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static Object[] getCollectionAsObjectArray(Object option, ObjectSpecification spec, AdapterManager adapterMap) {
        ObjectAdapter collection = adapterMap.adapterFor(option);
        CollectionFacet facet = CollectionFacet.Utils.getCollectionFacetFromSpec(collection);
        Object[] optionArray = new Object[facet.size(collection)];
        int j = 0;
        for (ObjectAdapter nextElement : facet.iterable(collection)) {
            optionArray[j++] = nextElement != null ? nextElement.getObject() : null;
        }
        return optionArray;
    }

    public static Object copyOf(Iterable<Object> iterable, Class<?> requiredType) {
        if (iterable == null) {
            throw new IllegalArgumentException("Iterable must be provided");
        }
        if (requiredType == null) {
            throw new IllegalArgumentException("RequiredType must be provided");
        }
        if (CopyOnWriteArrayList.class == requiredType) {
            return Lists.newCopyOnWriteArrayList(iterable);
        }
        if (LinkedList.class == requiredType) {
            return Lists.newLinkedList(iterable);
        }
        if (ArrayList.class == requiredType) {
            return Lists.newArrayList(iterable);
        }
        if (AbstractList.class == requiredType) {
            return Lists.newArrayList(iterable);
        }
        if (CopyOnWriteArraySet.class == requiredType) {
            return Sets.newCopyOnWriteArraySet(iterable);
        }
        if (LinkedHashSet.class == requiredType) {
            return Sets.newLinkedHashSet(iterable);
        }
        if (HashSet.class == requiredType) {
            return Sets.newHashSet(iterable);
        }
        if (TreeSet.class == requiredType) {
            Iterable<Object> rawIterable = iterable;
            return Sets.newTreeSet(rawIterable);
        }
        if (AbstractSet.class == requiredType) {
            return Sets.newLinkedHashSet(iterable);
        }
        if (List.class == requiredType) {
            return Lists.newArrayList(iterable);
        }
        if (SortedSet.class == requiredType) {
            Iterable<Object> rawIterable = iterable;
            return Sets.newTreeSet(rawIterable);
        }
        if (Set.class == requiredType) {
            return Sets.newLinkedHashSet(iterable);
        }
        if (Collection.class == requiredType) {
            return Lists.newArrayList(iterable);
        }
        if (requiredType.isArray()) {
            Class<?> componentType = requiredType.getComponentType();
            Iterable<Object> rawIterable = iterable;
            return Iterables.toArray(rawIterable, componentType);
        }
        return null;
    }
}

