/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import com.google.common.base.Function;
import java.lang.reflect.Method;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.TypedHolderDefault;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;

public class FacetedMethodParameter
extends TypedHolderDefault
implements IdentifiedHolder {
    private final Identifier identifier;

    public FacetedMethodParameter(Class<?> declaringType, Method method, Class<?> type) {
        super(FeatureType.ACTION_PARAMETER, type);
        this.identifier = FeatureType.ACTION.identifierFor(declaringType, method);
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    public static class Functions {
        public static final Function<FacetedMethodParameter, String> GET_NAME = new Function<FacetedMethodParameter, String>(){

            public String apply(FacetedMethodParameter input) {
                NamedFacet namedFacet = input.getFacet(NamedFacet.class);
                return namedFacet.value();
            }
        };
        public static final Function<FacetedMethodParameter, Class<?>> GET_TYPE = new Function<FacetedMethodParameter, Class<?>>(){

            public Class<?> apply(FacetedMethodParameter input) {
                return input.getType();
            }
        };

        private Functions() {
        }
    }
}

