/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactory;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public abstract class MethodPrefixBasedFacetFactoryAbstract
extends FacetFactoryAbstract
implements MethodPrefixBasedFacetFactory {
    private final List<String> prefixes;
    protected static final Object[] NO_PARAMETERS = new Object[0];
    protected static final Class<?>[] NO_PARAMETERS_TYPES = new Class[0];
    private final OrphanValidation orphanValidation;

    public MethodPrefixBasedFacetFactoryAbstract(List<FeatureType> featureTypes, OrphanValidation orphanValidation, String ... prefixes) {
        super(featureTypes);
        this.orphanValidation = orphanValidation;
        this.prefixes = Collections.unmodifiableList(Arrays.asList(prefixes));
    }

    @Override
    public List<String> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        if (this.orphanValidation == OrphanValidation.DONT_VALIDATE) {
            return;
        }
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                List<ObjectAction> objectActions = objectSpec.getObjectActions(Contributed.EXCLUDED);
                for (ObjectAction objectAction : objectActions) {
                    for (String prefix : MethodPrefixBasedFacetFactoryAbstract.this.prefixes) {
                        String actionId = objectAction.getId();
                        if (!actionId.startsWith(prefix) || prefix.length() >= actionId.length()) continue;
                        validationFailures.add("%s#%s: has prefix %s, is probably a supporting method for a property, collection or action.  If the method is intended to be an action, then rename and use @ActionLayout(named=\"...\") or ignore completely using @Programmatic", objectSpec.getIdentifier().getClassName(), actionId, prefix);
                    }
                }
                return true;
            }
        }));
    }

    protected static enum OrphanValidation {
        VALIDATE,
        DONT_VALIDATE;

    }
}

