/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionInteraction;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.annotation.Disabled;
import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.annotation.Idempotent;
import org.apache.isis.applib.annotation.PostsActionInvokedEvent;
import org.apache.isis.applib.annotation.Prototype;
import org.apache.isis.applib.annotation.PublishedAction;
import org.apache.isis.applib.annotation.QueryOnly;
import org.apache.isis.applib.annotation.TypeOf;
import org.apache.isis.applib.services.HasTransactionId;
import org.apache.isis.applib.services.eventbus.ActionDomainEvent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.facets.actions.action.bulk.BulkFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.bulk.BulkFacetForBulkAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetForCommandAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.disabled.DisabledFacetForDisabledAnnotationOnAction;
import org.apache.isis.core.metamodel.facets.actions.action.hidden.HiddenFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.hidden.HiddenFacetForHiddenAnnotationOnAction;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacetDefault;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacetForActionInteractionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventFromActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventFromActionInteractionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForPostsActionInvokedEventAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.prototype.PrototypeFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.prototype.PrototypeFacetForPrototypeAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishedActionFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishedActionFacetForPublishedActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.semantics.ActionSemanticsFacetFallbackToNonIdempotent;
import org.apache.isis.core.metamodel.facets.actions.action.semantics.ActionSemanticsFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.semantics.ActionSemanticsFacetForActionSemanticsAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.semantics.ActionSemanticsFacetFromIdempotentAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.semantics.ActionSemanticsFacetFromQueryOnlyAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.typeof.TypeOfFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.typeof.TypeOfFacetOnActionForTypeOfAnnotation;
import org.apache.isis.core.metamodel.facets.actions.bulk.BulkFacet;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.prototype.PrototypeFacet;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAware;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class ActionAnnotationFacetFactory
extends FacetFactoryAbstract
implements ServicesInjectorAware,
IsisConfigurationAware,
AdapterManagerAware,
RuntimeContextAware,
MetaModelValidatorRefiner {
    private final MetaModelValidatorForDeprecatedAnnotation actionSemanticsValidator = new MetaModelValidatorForDeprecatedAnnotation(ActionSemantics.class);
    private final MetaModelValidatorForDeprecatedAnnotation actionInteractionValidator = new MetaModelValidatorForDeprecatedAnnotation(ActionInteraction.class);
    private final MetaModelValidatorForDeprecatedAnnotation postsActionInvokedEventValidator = new MetaModelValidatorForDeprecatedAnnotation(PostsActionInvokedEvent.class);
    private final MetaModelValidatorForDeprecatedAnnotation bulkValidator = new MetaModelValidatorForDeprecatedAnnotation(Bulk.class);
    private final MetaModelValidatorForDeprecatedAnnotation commandValidator = new MetaModelValidatorForDeprecatedAnnotation(Command.class);
    private final MetaModelValidatorForDeprecatedAnnotation queryOnlyValidator = new MetaModelValidatorForDeprecatedAnnotation(QueryOnly.class);
    private final MetaModelValidatorForDeprecatedAnnotation idempotentValidator = new MetaModelValidatorForDeprecatedAnnotation(Idempotent.class);
    private final MetaModelValidatorForDeprecatedAnnotation publishedActionValidator = new MetaModelValidatorForDeprecatedAnnotation(PublishedAction.class);
    private final MetaModelValidatorForDeprecatedAnnotation typeOfValidator = new MetaModelValidatorForDeprecatedAnnotation(TypeOf.class);
    private final MetaModelValidatorForDeprecatedAnnotation hiddenValidator = new MetaModelValidatorForDeprecatedAnnotation(Hidden.class);
    private final MetaModelValidatorForDeprecatedAnnotation disabledValidator = new MetaModelValidatorForDeprecatedAnnotation(Disabled.class);
    private final MetaModelValidatorForDeprecatedAnnotation prototypeValidator = new MetaModelValidatorForDeprecatedAnnotation(Prototype.class);
    private ServicesInjector servicesInjector;
    private IsisConfiguration configuration;
    private AdapterManager adapterManager;
    private RuntimeContext runtimeContext;
    private final CollectionTypeRegistry collectionTypeRegistry = new CollectionTypeRegistry();

    public ActionAnnotationFacetFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.processInvocation(processMethodContext);
        this.processHidden(processMethodContext);
        this.processDisabled(processMethodContext);
        this.processRestrictTo(processMethodContext);
        this.processSemantics(processMethodContext);
        this.processBulk(processMethodContext);
        this.processCommand(processMethodContext);
        this.processPublishing(processMethodContext);
        this.processTypeOf(processMethodContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processInvocation(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        try {
            ActionInvocationFacetForDomainEventAbstract actionInvocationFacet;
            ActionDomainEventFacetAbstract actionDomainEventFacet;
            Class actionDomainEventType;
            Class<?> returnType = actionMethod.getReturnType();
            ObjectSpecification returnSpec = this.getSpecificationLoader().loadSpecification(returnType);
            if (returnSpec == null) {
                return;
            }
            Class<?> cls = processMethodContext.getCls();
            ObjectSpecification typeSpec = this.getSpecificationLoader().loadSpecification(cls);
            Object holder = processMethodContext.getFacetHolder();
            PostsActionInvokedEvent postsActionInvokedEvent = Annotations.getAnnotation(actionMethod, PostsActionInvokedEvent.class);
            ActionInteraction actionInteraction = Annotations.getAnnotation(actionMethod, ActionInteraction.class);
            Action action = Annotations.getAnnotation(actionMethod, Action.class);
            if (actionInteraction != null) {
                actionDomainEventType = actionInteraction.value();
                actionDomainEventFacet = new ActionDomainEventFacetForActionInteractionAnnotation((Class<? extends ActionDomainEvent<?>>)actionDomainEventType, this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)holder);
            } else if (action != null && action.domainEvent() != null) {
                actionDomainEventType = action.domainEvent();
                actionDomainEventFacet = new ActionDomainEventFacetForActionAnnotation((Class<? extends ActionDomainEvent<?>>)actionDomainEventType, this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)holder);
            } else {
                actionDomainEventType = ActionDomainEvent.Default.class;
                actionDomainEventFacet = new ActionDomainEventFacetDefault((Class<? extends ActionDomainEvent<?>>)actionDomainEventType, this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)holder);
            }
            FacetUtil.addFacet(actionDomainEventFacet);
            if (postsActionInvokedEvent != null) {
                Class actionInvokedEventType = postsActionInvokedEvent.value();
                actionInvocationFacet = this.actionInteractionValidator.flagIfPresent(new ActionInvocationFacetForPostsActionInvokedEventAnnotation(actionInvokedEventType, actionMethod, typeSpec, returnSpec, (FacetHolder)holder, this.getRuntimeContext(), this.getAdapterManager(), this.getServicesInjector(), this.configuration), processMethodContext);
            } else {
                actionInvocationFacet = actionInteraction != null ? (ActionInvocationFacetForDomainEventAbstract)this.actionInteractionValidator.flagIfPresent(new ActionInvocationFacetForDomainEventFromActionInteractionAnnotation(actionDomainEventType, actionMethod, typeSpec, returnSpec, (FacetHolder)holder, this.getRuntimeContext(), this.getAdapterManager(), this.getServicesInjector(), this.configuration), processMethodContext) : (action != null ? new ActionInvocationFacetForDomainEventFromActionAnnotation(actionDomainEventType, actionMethod, typeSpec, returnSpec, (FacetHolder)holder, this.getRuntimeContext(), this.getAdapterManager(), this.getServicesInjector(), this.configuration) : new ActionInvocationFacetForDomainEventFromDefault(actionDomainEventType, actionMethod, typeSpec, returnSpec, (FacetHolder)holder, this.getRuntimeContext(), this.getAdapterManager(), this.getServicesInjector(), this.configuration));
            }
            FacetUtil.addFacet(actionInvocationFacet);
        }
        finally {
            processMethodContext.removeMethod(actionMethod);
        }
    }

    void processHidden(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Hidden hiddenAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Hidden.class);
        HiddenFacet facet = this.hiddenValidator.flagIfPresent(HiddenFacetForHiddenAnnotationOnAction.create(hiddenAnnotation, holder), processMethodContext);
        Action action = Annotations.getAnnotation(method, Action.class);
        if (facet == null) {
            facet = HiddenFacetForActionAnnotation.create(action, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processDisabled(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Disabled annotation = Annotations.getAnnotation(method, Disabled.class);
        DisabledFacet facet = this.disabledValidator.flagIfPresent(DisabledFacetForDisabledAnnotationOnAction.create(annotation, holder), processMethodContext);
        FacetUtil.addFacet(facet);
    }

    void processRestrictTo(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Prototype annotation = Annotations.getAnnotation(method, Prototype.class);
        PrototypeFacet facet1 = PrototypeFacetForPrototypeAnnotation.create(annotation, holder);
        FacetUtil.addFacet(this.prototypeValidator.flagIfPresent(facet1, processMethodContext));
        PrototypeFacet facet = facet1;
        Action action = Annotations.getAnnotation(method, Action.class);
        if (facet == null) {
            facet = PrototypeFacetForActionAnnotation.create(action, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processSemantics(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        QueryOnly queryOnly = Annotations.getAnnotation(processMethodContext.getMethod(), QueryOnly.class);
        ActionSemanticsFacet facet = this.queryOnlyValidator.flagIfPresent(ActionSemanticsFacetFromQueryOnlyAnnotation.create(queryOnly, holder), processMethodContext);
        if (facet == null) {
            Idempotent idempotent = Annotations.getAnnotation(processMethodContext.getMethod(), Idempotent.class);
            facet = this.idempotentValidator.flagIfPresent(ActionSemanticsFacetFromIdempotentAnnotation.create(idempotent, holder), processMethodContext);
        }
        if (facet == null) {
            ActionSemantics actionSemantics = Annotations.getAnnotation(method, ActionSemantics.class);
            facet = this.actionSemanticsValidator.flagIfPresent(ActionSemanticsFacetForActionSemanticsAnnotation.create(actionSemantics, holder), processMethodContext);
        }
        if (facet == null) {
            Action action = Annotations.getAnnotation(method, Action.class);
            facet = ActionSemanticsFacetForActionAnnotation.create(action, holder);
        }
        if (facet == null) {
            facet = new ActionSemanticsFacetFallbackToNonIdempotent((FacetHolder)holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processBulk(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Action action = Annotations.getAnnotation(method, Action.class);
        Object holder = processMethodContext.getFacetHolder();
        Bulk annotation = Annotations.getAnnotation(method, Bulk.class);
        BulkFacet facet = this.bulkValidator.flagIfPresent(BulkFacetForBulkAnnotation.create(annotation, holder), processMethodContext);
        if (facet == null) {
            facet = BulkFacetForActionAnnotation.create(action, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processCommand(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetHolder;
        Class<?> cls = processMethodContext.getCls();
        Method method = processMethodContext.getMethod();
        Action action = Annotations.getAnnotation(method, Action.class);
        FacetedMethod holder = facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        if (HasTransactionId.class.isAssignableFrom(processMethodContext.getCls())) {
            return;
        }
        Command annotation = Annotations.getAnnotation(method, Command.class);
        CommandFacet commandFacet = this.commandValidator.flagIfPresent(CommandFacetForCommandAnnotation.create(annotation, processMethodContext.getFacetHolder()), processMethodContext);
        if (commandFacet == null) {
            commandFacet = CommandFacetForActionAnnotation.create(action, this.configuration, holder);
        }
        FacetUtil.addFacet(commandFacet);
    }

    void processPublishing(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Action action = Annotations.getAnnotation(method, Action.class);
        Object holder = processMethodContext.getFacetHolder();
        if (HasTransactionId.class.isAssignableFrom(processMethodContext.getCls())) {
            return;
        }
        PublishedAction annotation = Annotations.getAnnotation(processMethodContext.getMethod(), PublishedAction.class);
        PublishedActionFacet facet = this.publishedActionValidator.flagIfPresent(PublishedActionFacetForPublishedActionAnnotation.create(annotation, holder), processMethodContext);
        if (facet == null) {
            facet = PublishedActionFacetForActionAnnotation.create(action, this.configuration, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processTypeOf(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType;
        Class typeOf;
        Action action;
        Method method = processMethodContext.getMethod();
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        Class<?> methodReturnType = method.getReturnType();
        if (!this.collectionTypeRegistry.isCollectionType(methodReturnType) && !this.collectionTypeRegistry.isArrayType(methodReturnType)) {
            return;
        }
        TypeOf annotation = Annotations.getAnnotation(method, TypeOf.class);
        TypeOfFacet facet = this.typeOfValidator.flagIfPresent(TypeOfFacetOnActionForTypeOfAnnotation.create(annotation, this.getSpecificationLoader(), holder), processMethodContext);
        if (facet == null && (action = Annotations.getAnnotation(method, Action.class)) != null && (typeOf = action.typeOf()) != null && typeOf != Object.class) {
            facet = new TypeOfFacetForActionAnnotation(typeOf, this.getSpecificationLoader(), holder);
        }
        if (facet == null && (returnType = method.getReturnType()).isArray()) {
            Class<?> componentType = returnType.getComponentType();
            facet = new TypeOfFacetInferredFromArray(componentType, (FacetHolder)holder, this.getSpecificationLoader());
        }
        if (facet == null) {
            facet = this.inferFromGenericReturnType(processMethodContext);
        }
        FacetUtil.addFacet(facet);
    }

    private TypeOfFacet inferFromGenericReturnType(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType methodParameterizedType = (ParameterizedType)type;
        Type[] methodActualTypeArguments = methodParameterizedType.getActualTypeArguments();
        if (methodActualTypeArguments.length == 0) {
            return null;
        }
        Type methodActualTypeArgument = methodActualTypeArguments[0];
        if (methodActualTypeArgument instanceof Class) {
            Class actualType = (Class)methodActualTypeArgument;
            return new TypeOfFacetInferredFromGenerics(actualType, (FacetHolder)holder, this.getSpecificationLoader());
        }
        if (methodActualTypeArgument instanceof TypeVariable) {
            ParameterizedType parameterizedTypeOfSuperclass;
            TypeVariable methodTypeVariable = (TypeVariable)methodActualTypeArgument;
            Object methodGenericClassDeclaration = methodTypeVariable.getGenericDeclaration();
            Type genericSuperclass = processMethodContext.getCls().getGenericSuperclass();
            if (genericSuperclass instanceof ParameterizedType && (parameterizedTypeOfSuperclass = (ParameterizedType)genericSuperclass).getRawType() == methodGenericClassDeclaration) {
                Type actualType;
                Type[] genericSuperClassActualTypeArguments = parameterizedTypeOfSuperclass.getActualTypeArguments();
                if (methodActualTypeArguments.length == 1 && (actualType = genericSuperClassActualTypeArguments[0]) instanceof Class) {
                    Class actualCls = (Class)actualType;
                    return new TypeOfFacetInferredFromGenerics(actualCls, (FacetHolder)holder, this.getSpecificationLoader());
                }
            }
        }
        return null;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.actionSemanticsValidator);
        metaModelValidator.add(this.actionInteractionValidator);
        metaModelValidator.add(this.postsActionInvokedEventValidator);
        metaModelValidator.add(this.bulkValidator);
        metaModelValidator.add(this.commandValidator);
        metaModelValidator.add(this.queryOnlyValidator);
        metaModelValidator.add(this.idempotentValidator);
        metaModelValidator.add(this.publishedActionValidator);
        metaModelValidator.add(this.typeOfValidator);
        metaModelValidator.add(this.hiddenValidator);
        metaModelValidator.add(this.disabledValidator);
        metaModelValidator.add(this.prototypeValidator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
        this.actionSemanticsValidator.setConfiguration(configuration);
        this.actionInteractionValidator.setConfiguration(configuration);
        this.postsActionInvokedEventValidator.setConfiguration(configuration);
        this.bulkValidator.setConfiguration(configuration);
        this.commandValidator.setConfiguration(configuration);
        this.queryOnlyValidator.setConfiguration(configuration);
        this.idempotentValidator.setConfiguration(configuration);
        this.publishedActionValidator.setConfiguration(configuration);
        this.typeOfValidator.setConfiguration(configuration);
        this.hiddenValidator.setConfiguration(configuration);
        this.disabledValidator.setConfiguration(configuration);
        this.prototypeValidator.setConfiguration(configuration);
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    private ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

