/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.invocation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;

public class CommandUtil {
    private CommandUtil() {
    }

    public static String targetActionNameFor(ObjectAction owningAction) {
        return owningAction.getName();
    }

    public static String targetClassNameFor(ObjectAdapter targetAdapter) {
        return StringExtensions.asNaturalName2(targetAdapter.getSpecification().getSingularName());
    }

    public static String actionIdentifierFor(ObjectAction owningAction) {
        return owningAction.getIdentifier().toClassAndNameIdentityString();
    }

    public static String argDescriptionFor(ObjectAction owningAction, ObjectAdapter[] arguments) {
        StringBuilder argsBuf = new StringBuilder();
        List<ObjectActionParameter> parameters = owningAction.getParameters();
        if (parameters.size() == arguments.length) {
            int i = 0;
            for (ObjectActionParameter param : parameters) {
                CommandUtil.appendParamArg(argsBuf, param, arguments[i++]);
            }
        }
        String argsStr = argsBuf.toString();
        return argsStr;
    }

    public static Bookmark bookmarkFor(ObjectAdapter adapter) {
        Oid oid = adapter.getOid();
        if (!(oid instanceof RootOid)) {
            return null;
        }
        RootOid rootOid = (RootOid)oid;
        return rootOid.asBookmark();
    }

    static void appendParamArg(StringBuilder buf, ObjectActionParameter param, ObjectAdapter objectAdapter) {
        String titleOf = objectAdapter != null ? objectAdapter.titleString(null) : "null";
        buf.append(param.getName()).append(": ").append(titleOf).append("\n");
    }

    public static void buildMementoArgLists(MementoService mementoService, BookmarkService bookmarkService, Method method, Object[] args, List<Class<?>> argTypes, List<Object> argObjs) {
        for (int i = 0; i < args.length; ++i) {
            Object input = args[i];
            if (mementoService.canSet(input)) {
                argTypes.add(method.getParameterTypes()[i]);
                argObjs.add(input);
                continue;
            }
            Bookmark argBookmark = bookmarkService.bookmarkFor(input);
            argTypes.add(Bookmark.class);
            argObjs.add(argBookmark);
        }
    }

    public static ObjectAdapter[] adaptersFor(Object[] args, AdapterManager adapterManager) {
        List<Object> argList = Arrays.asList(args);
        Iterable adapterList = Iterables.transform(argList, ObjectAdapter.Functions.adapterForUsing(adapterManager));
        return Lists.newArrayList((Iterable)adapterList).toArray(new ObjectAdapter[0]);
    }

    public static Object[] objectsFor(ObjectAdapter[] arguments) {
        List<ObjectAdapter> argList = Arrays.asList(arguments);
        Iterable adapterList = Iterables.transform(argList, ObjectAdapter.Functions.getObject());
        return Lists.newArrayList((Iterable)adapterList).toArray(new Object[0]);
    }
}

