/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.interaction;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.interaction.DebugFacetViaNamingConvention;
import org.apache.isis.core.metamodel.facets.actions.interaction.ExplorationFacetViaNamingConvention;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacetInferred;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedMethodPrefix;

@Deprecated
public class ActionNamedDebugExplorationFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements MetaModelValidatorRefiner,
IsisConfigurationAware {
    private static final String EXPLORATION_PREFIX = "Exploration";
    private static final String DEBUG_PREFIX = "Debug";
    private final MetaModelValidatorForDeprecatedMethodPrefix explorationValidator = new MetaModelValidatorForDeprecatedMethodPrefix("Exploration");
    private final MetaModelValidatorForDeprecatedMethodPrefix debugValidator = new MetaModelValidatorForDeprecatedMethodPrefix("Debug");
    private static final String[] PREFIXES = new String[]{"Exploration", "Debug"};

    public ActionNamedDebugExplorationFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachDebugFacetIfActionMethodNamePrefixed(processMethodContext);
        this.attachExplorationFacetIfActionMethodNamePrefixed(processMethodContext);
        this.attachNamedFacetInferredFromMethodName(processMethodContext);
    }

    private void attachDebugFacetIfActionMethodNamePrefixed(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        if (!capitalizedName.startsWith(DEBUG_PREFIX)) {
            return;
        }
        Object facetedMethod = processMethodContext.getFacetHolder();
        DebugFacetViaNamingConvention facet = new DebugFacetViaNamingConvention((FacetHolder)facetedMethod);
        FacetUtil.addFacet(this.debugValidator.flagIfPresent(facet, processMethodContext));
    }

    private void attachExplorationFacetIfActionMethodNamePrefixed(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        if (!capitalizedName.startsWith(EXPLORATION_PREFIX)) {
            return;
        }
        Object facetedMethod = processMethodContext.getFacetHolder();
        ExplorationFacetViaNamingConvention facet = new ExplorationFacetViaNamingConvention((FacetHolder)facetedMethod);
        FacetUtil.addFacet(this.explorationValidator.flagIfPresent(facet, processMethodContext));
    }

    private void attachNamedFacetInferredFromMethodName(FacetFactory.ProcessMethodContext processMethodContext) {
        String capitalizedName;
        Method method = processMethodContext.getMethod();
        String name = capitalizedName = StringExtensions.asCapitalizedName(method.getName());
        name = StringExtensions.removePrefix(name, DEBUG_PREFIX);
        name = StringExtensions.removePrefix(name, EXPLORATION_PREFIX);
        name = StringExtensions.asNaturalName2(name);
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new NamedFacetInferred(name, (FacetHolder)facetedMethod));
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.explorationValidator);
        metaModelValidator.add(this.debugValidator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.explorationValidator.setConfiguration(configuration);
        this.debugValidator.setConfiguration(configuration);
    }
}

