/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.validate.method;

import java.lang.reflect.Method;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.validate.method.ActionParameterValidationFacetViaMethod;
import org.apache.isis.core.metamodel.facets.actions.validate.method.ActionValidationFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class ActionValidationFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements ServicesInjectorAware {
    private static final String[] PREFIXES = new String[]{"validate"};
    private ServicesInjector servicesInjector;

    public ActionValidationFacetViaMethodFactory() {
        super(FeatureType.ACTIONS_AND_PARAMETERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.handleValidateAllArgsMethod(processMethodContext);
    }

    private void handleValidateAllArgsMethod(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        IdentifiedHolder facetHolder = (IdentifiedHolder)processMethodContext.getFacetHolder();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        Class<?>[] paramTypes = actionMethod.getParameterTypes();
        MethodScope onClass = MethodScope.scopeFor(actionMethod);
        Method validateMethod = MethodFinderUtils.findMethod(cls, onClass, "validate" + capitalizedName, new Class[]{String.class, TranslatableString.class}, paramTypes);
        if (validateMethod == null) {
            return;
        }
        processMethodContext.removeMethod(validateMethod);
        TranslationService translationService = this.servicesInjector.lookupService(TranslationService.class);
        String translationContext = facetHolder.getIdentifier().toClassAndNameIdentityString();
        ActionValidationFacetViaMethod facet = new ActionValidationFacetViaMethod(validateMethod, translationService, translationContext, facetHolder);
        FacetUtil.addFacet(facet);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Class<?> cls = processParameterContext.getCls();
        Method actionMethod = processParameterContext.getMethod();
        int param = processParameterContext.getParamNum();
        IdentifiedHolder facetHolder = (IdentifiedHolder)processParameterContext.getFacetHolder();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        Class<?>[] paramTypes = actionMethod.getParameterTypes();
        MethodScope onClass = MethodScope.scopeFor(actionMethod);
        String validateName = "validate" + param + capitalizedName;
        Method validateMethod = MethodFinderUtils.findMethod(cls, onClass, validateName, new Class[]{String.class, TranslatableString.class}, new Class[]{paramTypes[param]});
        if (validateMethod == null) {
            return;
        }
        processParameterContext.removeMethod(validateMethod);
        TranslationService translationService = this.servicesInjector.lookupService(TranslationService.class);
        String translationContext = facetHolder.getIdentifier().toFullIdentityString();
        ActionParameterValidationFacetViaMethod facet = new ActionParameterValidationFacetViaMethod(validateMethod, translationService, translationContext, facetHolder);
        FacetUtil.addFacet(facet);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

