/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.all.i18n;

import com.google.common.base.Strings;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.i18n.DescribedAsFacetTranslated;
import org.apache.isis.core.metamodel.facets.all.i18n.NamedFacetTranslated;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class TranslationFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
ServicesInjectorAware {
    private ServicesInjector servicesInjector;
    private TranslationService translationService;

    public TranslationFacetFactory() {
        super(FeatureType.EVERYTHING);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Object facetHolder = processClassContext.getFacetHolder();
        if (facetHolder instanceof IdentifiedHolder) {
            IdentifiedHolder holder = (IdentifiedHolder)facetHolder;
            String context = holder.getIdentifier().toClassIdentityString();
            this.translateName(holder, context);
            this.translateDescription(holder, context);
        }
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        IdentifiedHolder holder = (IdentifiedHolder)processMethodContext.getFacetHolder();
        String context = holder.getIdentifier().toClassAndNameIdentityString();
        this.translateName(holder, context);
        this.translateDescription(holder, context);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        IdentifiedHolder holder = (IdentifiedHolder)processParameterContext.getFacetHolder();
        String context = holder.getIdentifier().toFullIdentityString();
        this.translateName(holder, context);
        this.translateDescription(holder, context);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        IdentifiedHolder holder = (IdentifiedHolder)processMemberContext.getFacetHolder();
        String context = holder.getIdentifier().toClassAndNameIdentityString();
        this.translateName(holder, context);
        this.translateDescription(holder, context);
    }

    void translateName(IdentifiedHolder facetHolder, String context) {
        NamedFacet facet = facetHolder.getFacet(NamedFacet.class);
        if (facet == null) {
            return;
        }
        String originalText = facet.value();
        if (this.isNullOrEmptyWhenTrimmed(originalText)) {
            return;
        }
        TranslationService translationService = this.lookupTranslationService();
        FacetUtil.addFacet(new NamedFacetTranslated(context, originalText, translationService, facetHolder));
    }

    void translateDescription(FacetHolder facetHolder, String context) {
        IdentifiedHolder holder = (IdentifiedHolder)facetHolder;
        DescribedAsFacet facet = facetHolder.getFacet(DescribedAsFacet.class);
        if (facet == null) {
            return;
        }
        String originalText = facet.value();
        if (this.isNullOrEmptyWhenTrimmed(originalText)) {
            return;
        }
        TranslationService translationService = this.lookupTranslationService();
        FacetUtil.addFacet(new DescribedAsFacetTranslated(context, originalText, translationService, holder));
    }

    private boolean isNullOrEmptyWhenTrimmed(String originalText) {
        return originalText == null || Strings.isNullOrEmpty((String)originalText.trim());
    }

    TranslationService lookupTranslationService() {
        if (this.translationService == null) {
            this.translationService = this.servicesInjector.lookupService(TranslationService.class);
        }
        return this.translationService;
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

