/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.accessor;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.PropertyOrCollectionIdentifyingFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.collections.accessor.CollectionAccessorFacetViaAccessor;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class CollectionAccessorFacetViaAccessorFactory
extends PropertyOrCollectionIdentifyingFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"get"};

    public CollectionAccessorFacetViaAccessorFactory() {
        super(FeatureType.COLLECTIONS_ONLY, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachAccessorFacetForAccessorMethod(processMethodContext);
    }

    private void attachAccessorFacetForAccessorMethod(FacetFactory.ProcessMethodContext processMethodContext) {
        Method accessorMethod = processMethodContext.getMethod();
        processMethodContext.removeMethod(accessorMethod);
        Object holder = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new CollectionAccessorFacetViaAccessor(accessorMethod, (FacetHolder)holder, this.getAdapterManager(), this.getSpecificationLoader(), this.getConfiguration()));
    }

    @Override
    public boolean isPropertyOrCollectionAccessorCandidate(Method method) {
        return method.getName().startsWith("get");
    }

    @Override
    public boolean isCollectionAccessor(Method method) {
        if (!this.isPropertyOrCollectionAccessorCandidate(method)) {
            return false;
        }
        Class<?> methodReturnType = method.getReturnType();
        return this.isCollectionOrArray(methodReturnType);
    }

    @Override
    public boolean isPropertyAccessor(Method method) {
        return false;
    }

    @Override
    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        Class<?>[] collectionClasses;
        for (Class<?> returnType : collectionClasses = this.getCollectionTypeRepository().getCollectionType()) {
            List<Method> list = methodRemover.removeMethods(MethodScope.OBJECT, "get", returnType, false, 0);
            methodListToAppendTo.addAll(list);
        }
    }

    @Override
    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
    }
}

