/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.javautilcollection;

import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetDefaultToObject;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.facets.collections.javautilcollection.JavaArrayFacet;
import org.apache.isis.core.metamodel.facets.collections.javautilcollection.JavaCollectionFacet;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;

public class CollectionFacetFactory
extends FacetFactoryAbstract
implements AdapterManagerAware {
    private final CollectionTypeRegistry collectionTypeRegistry = new CollectionTypeRegistry();
    private AdapterManager adapterManager;

    public CollectionFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        if (this.collectionTypeRegistry.isCollectionType(processClassContaxt.getCls())) {
            this.processCollectionType(processClassContaxt);
        } else if (this.collectionTypeRegistry.isArrayType(processClassContaxt.getCls())) {
            this.processAsArrayType(processClassContaxt);
        }
    }

    private void processCollectionType(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        TypeOfFacet facetHolder = processClassContext.getFacetHolder();
        TypeOfFacet typeOfFacet = facetHolder.getFacet(TypeOfFacet.class);
        if (typeOfFacet == null) {
            Class<?> collectionElementType = this.collectionElementType(cls);
            typeOfFacet = collectionElementType != Object.class ? new TypeOfFacetInferredFromGenerics(collectionElementType, (FacetHolder)((Object)facetHolder), this.getSpecificationLoader()) : new TypeOfFacetDefaultToObject((FacetHolder)((Object)facetHolder), this.getSpecificationLoader());
            facetHolder.addFacet(typeOfFacet);
        }
        JavaCollectionFacet collectionFacet = new JavaCollectionFacet((FacetHolder)((Object)facetHolder), this.getAdapterManager());
        facetHolder.addFacet(collectionFacet);
    }

    private void processAsArrayType(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        JavaArrayFacet collectionFacet = new JavaArrayFacet((FacetHolder)facetHolder, this.getAdapterManager());
        facetHolder.addFacet(collectionFacet);
        TypeOfFacetInferredFromArray typeOfFacet = new TypeOfFacetInferredFromArray(cls.getComponentType(), (FacetHolder)facetHolder, this.getSpecificationLoader());
        facetHolder.addFacet(typeOfFacet);
    }

    private Class<?> collectionElementType(Class<?> cls) {
        return Object.class;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }
}

