/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.javautilcollection;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Iterator;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.collections.CollectionFacetAbstract;

public class JavaCollectionFacet
extends CollectionFacetAbstract {
    private final AdapterManager adapterManager;

    public JavaCollectionFacet(FacetHolder holder, AdapterManager adapterManager) {
        super(holder);
        this.adapterManager = adapterManager;
    }

    @Override
    public Collection<ObjectAdapter> collection(ObjectAdapter wrappedCollection) {
        Collection<? super Object> collectionOfUnderlying = this.collectionOfUnderlying(wrappedCollection);
        return Collections2.transform(collectionOfUnderlying, ObjectAdapter.Functions.adapterForUsing(this.getAdapterManager()));
    }

    @Override
    public ObjectAdapter firstElement(ObjectAdapter collection) {
        Iterator<ObjectAdapter> iterator = this.iterator(collection);
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public int size(ObjectAdapter collection) {
        return this.collectionOfUnderlying(collection).size();
    }

    @Override
    public void init(ObjectAdapter collection, ObjectAdapter[] initData) {
        Collection<? super Object> javaCollection = this.collectionOfUnderlying(collection);
        javaCollection.clear();
        for (ObjectAdapter element : initData) {
            Object pojo = element.getObject();
            javaCollection.add(pojo);
        }
    }

    private Collection<? super Object> collectionOfUnderlying(ObjectAdapter wrappedCollection) {
        return (Collection)wrappedCollection.getObject();
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

