/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.modify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public interface CollectionFacet
extends Facet {
    public int size(ObjectAdapter var1);

    public Iterable<ObjectAdapter> iterable(ObjectAdapter var1);

    public Iterator<ObjectAdapter> iterator(ObjectAdapter var1);

    public Collection<ObjectAdapter> collection(ObjectAdapter var1);

    public ObjectAdapter firstElement(ObjectAdapter var1);

    public boolean contains(ObjectAdapter var1, ObjectAdapter var2);

    public void init(ObjectAdapter var1, ObjectAdapter[] var2);

    public TypeOfFacet getTypeOfFacet();

    public static class Utils {
        public static CollectionFacet getCollectionFacetFromSpec(ObjectAdapter objectRepresentingCollection) {
            ObjectSpecification collectionSpec = objectRepresentingCollection.getSpecification();
            return collectionSpec.getFacet(CollectionFacet.class);
        }

        public static int size(ObjectAdapter collection) {
            CollectionFacet facet = Utils.getCollectionFacetFromSpec(collection);
            return facet.size(collection);
        }

        public static List<ObjectAdapter> convertToAdapterList(ObjectAdapter collection) {
            CollectionFacet facet = Utils.getCollectionFacetFromSpec(collection);
            ArrayList<ObjectAdapter> adapters = new ArrayList<ObjectAdapter>();
            for (ObjectAdapter adapter : facet.iterable(collection)) {
                adapters.add(adapter);
            }
            return adapters;
        }
    }
}

