/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.named.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.named.staticmethod.NamedFacetStaticMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedMethodPrefix;

@Deprecated
public class NamedFacetStaticMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements MetaModelValidatorRefiner,
IsisConfigurationAware {
    private static final String[] PREFIXES = new String[]{"name"};
    private final MetaModelValidatorForDeprecatedMethodPrefix validator = new MetaModelValidatorForDeprecatedMethodPrefix(PREFIXES[0]);

    public NamedFacetStaticMethodFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachNamedFacetIfNamedMethodIsFound(processMethodContext);
    }

    public void attachNamedFacetIfNamedMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Class<?> cls = processMethodContext.getCls();
        Method nameMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "name" + capitalizedName, String.class, new Class[0]);
        if (nameMethod == null) {
            return;
        }
        processMethodContext.removeMethod(nameMethod);
        String name = NamedFacetStaticMethodFactory.invokeNameMethod(nameMethod);
        Object facetHolder = processMethodContext.getFacetHolder();
        NamedFacetStaticMethod facet = new NamedFacetStaticMethod(name, nameMethod, (FacetHolder)facetHolder);
        FacetUtil.addFacet(this.validator.flagIfPresent(facet, processMethodContext));
    }

    private static String invokeNameMethod(Method nameMethod) {
        String name = null;
        try {
            name = (String)MethodExtensions.invokeStatic(nameMethod);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (name == null) {
            throw new MetaModelException("method " + nameMethod + "must return a string");
        }
        return name;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.validator.setConfiguration(configuration);
    }
}

