/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.order.annotprop;

import java.util.Properties;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.members.order.annotprop.MemberOrderFacetAnnotation;
import org.apache.isis.core.metamodel.facets.members.order.annotprop.MemberOrderFacetProperties;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class MemberOrderFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
ServicesInjectorAware {
    private ServicesInjector servicesInjector;

    public MemberOrderFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        MemberOrderFacet memberOrderFacet = this.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (memberOrderFacet == null) {
            memberOrderFacet = this.createFromAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(memberOrderFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        MemberOrderFacet memberOrderFacet = this.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(memberOrderFacet);
    }

    private MemberOrderFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("memberOrder");
        MemberOrderFacetProperties memberOrderFacet = properties != null ? new MemberOrderFacetProperties(properties, this.servicesInjector.lookupService(TranslationService.class), holder) : null;
        return memberOrderFacet;
    }

    private MemberOrderFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        MemberOrder annotation = Annotations.getAnnotation(processMethodContext.getMethod(), MemberOrder.class);
        if (annotation != null) {
            return new MemberOrderFacetAnnotation(annotation.name(), annotation.sequence(), this.servicesInjector.lookupService(TranslationService.class), (FacetHolder)processMethodContext.getFacetHolder());
        }
        return null;
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

