/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.autocomplete;

import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;

public abstract class AutoCompleteFacetAbstract
extends FacetAbstract
implements AutoCompleteFacet {
    private final Class<?> repositoryClass;
    private final String actionName;
    private final SpecificationLoader specificationLoader;
    private final AdapterManager adapterManager;
    private final ServicesInjector servicesInjector;
    private ObjectAction repositoryAction;
    private boolean cachedRepositoryAction = false;
    private boolean cachedRepositoryObject = false;
    private Object repository;

    public static Class<? extends Facet> type() {
        return AutoCompleteFacet.class;
    }

    public AutoCompleteFacetAbstract(FacetHolder holder, Class<?> repositoryClass, String actionName, SpecificationLoader specificationLoader, AdapterManager adapterManager, ServicesInjector servicesInjector) {
        super(AutoCompleteFacetAbstract.type(), holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.repositoryClass = repositoryClass;
        this.actionName = actionName;
        this.specificationLoader = specificationLoader;
        this.adapterManager = adapterManager;
        this.servicesInjector = servicesInjector;
    }

    @Override
    public List<ObjectAdapter> execute(String search, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        ObjectAdapter searchAdapter;
        this.cacheRepositoryAndRepositoryActionIfRequired();
        if (this.repositoryAction == null || this.repository == null) {
            return Collections.emptyList();
        }
        ObjectAdapter repositoryAdapter = this.adapterManager.getAdapterFor(this.repository);
        ObjectAdapter resultAdapter = this.repositoryAction.execute(repositoryAdapter, new ObjectAdapter[]{searchAdapter = this.adapterManager.adapterFor(search)});
        if (CollectionFacet.Utils.getCollectionFacetFromSpec(resultAdapter) == null) {
            return Collections.emptyList();
        }
        ObjectSpecification objectSpecification = (ObjectSpecification)this.getFacetHolder();
        CollectionFacet facet = CollectionFacet.Utils.getCollectionFacetFromSpec(resultAdapter);
        Iterable<ObjectAdapter> adapterList = facet.iterable(resultAdapter);
        return ObjectAdapter.Util.visibleAdapters(adapterList, authenticationSession, deploymentCategory);
    }

    private void cacheRepositoryAndRepositoryActionIfRequired() {
        if (!this.cachedRepositoryAction) {
            this.cacheRepositoryAction();
        }
        if (!this.cachedRepositoryObject) {
            this.cacheRepositoryObject();
        }
    }

    private void cacheRepositoryAction() {
        try {
            ObjectSpecification repositorySpec = this.specificationLoader.loadSpecification(this.repositoryClass);
            List<ObjectAction> objectActions = repositorySpec.getObjectActions(ActionType.USER, Contributed.EXCLUDED, ObjectAction.Filters.withId(this.actionName));
            this.repositoryAction = objectActions.size() == 1 ? objectActions.get(0) : null;
        }
        finally {
            this.cachedRepositoryAction = true;
        }
    }

    private void cacheRepositoryObject() {
        this.repository = this.servicesInjector.lookupService(this.repositoryClass);
        this.cachedRepositoryObject = true;
    }
}

