/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.defaults.annotcfg;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Defaulted;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.defaults.DefaultedFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.defaults.DefaultsProviderUtil;
import org.apache.isis.core.metamodel.facets.object.defaults.annotcfg.DefaultedFacetAnnotation;
import org.apache.isis.core.metamodel.facets.object.defaults.annotcfg.DefaultedFacetFromConfiguration;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class DefaultedFacetAnnotationElseConfigurationFactory
extends FacetFactoryAbstract
implements IsisConfigurationAware,
ServicesInjectorAware {
    private IsisConfiguration configuration;
    private ServicesInjector servicesInjector;

    public DefaultedFacetAnnotationElseConfigurationFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        FacetUtil.addFacet(this.create(processClassContext.getCls(), (FacetHolder)processClassContext.getFacetHolder()));
    }

    private DefaultedFacetAbstract create(Class<?> cls, FacetHolder holder) {
        DefaultedFacetFromConfiguration facet;
        DefaultedFacetAnnotation facet2;
        Defaulted annotation = Annotations.getAnnotation(cls, Defaulted.class);
        if (annotation != null && (facet2 = new DefaultedFacetAnnotation(cls, this.getIsisConfiguration(), holder, this.getServicesInjector())).isValid()) {
            return facet2;
        }
        String providerName = DefaultsProviderUtil.defaultsProviderNameFromConfiguration(cls, this.getIsisConfiguration());
        if (!Strings.isNullOrEmpty((String)providerName) && (facet = new DefaultedFacetFromConfiguration(providerName, holder, this.getServicesInjector())).isValid()) {
            return facet;
        }
        return null;
    }

    public IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    private ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    @Override
    public void setServicesInjector(ServicesInjector dependencyInjector) {
        this.servicesInjector = dependencyInjector;
    }
}

