/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import org.apache.isis.applib.annotation.Audited;
import org.apache.isis.applib.annotation.AutoComplete;
import org.apache.isis.applib.annotation.Bounded;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Immutable;
import org.apache.isis.applib.annotation.ObjectType;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.services.HasTransactionId;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.adapter.QuerySubmitter;
import org.apache.isis.core.metamodel.adapter.QuerySubmitterAware;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetForAuditedAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.autocomplete.AutoCompleteFacetForAutoCompleteAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.autocomplete.AutoCompleteFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.choices.ChoicesFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.choices.ChoicesFacetFromBoundedAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.ImmutableFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.objectspecid.ObjectSpecIdFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.objectspecid.ObjectSpecIdFacetForJdoPersistenceCapableAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.objectspecid.ObjectSpecIdFacetFromObjectTypeAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetForPublishedObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.recreatable.RecreatableObjectFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.immutable.immutableannot.ImmutableFacetForImmutableAnnotation;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderAware;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

public class DomainObjectAnnotationFacetFactory
extends FacetFactoryAbstract
implements IsisConfigurationAware,
AdapterManagerAware,
ServicesInjectorAware,
SpecificationLoaderAware,
QuerySubmitterAware,
MetaModelValidatorRefiner {
    private final MetaModelValidatorForDeprecatedAnnotation auditedValidator = new MetaModelValidatorForDeprecatedAnnotation(Audited.class);
    private final MetaModelValidatorForDeprecatedAnnotation publishedObjectValidator = new MetaModelValidatorForDeprecatedAnnotation(PublishedObject.class);
    private final MetaModelValidatorForDeprecatedAnnotation autoCompleteValidator = new MetaModelValidatorForDeprecatedAnnotation(AutoComplete.class);
    private final MetaModelValidatorForDeprecatedAnnotation boundedValidator = new MetaModelValidatorForDeprecatedAnnotation(Bounded.class);
    private final MetaModelValidatorForDeprecatedAnnotation immutableValidator = new MetaModelValidatorForDeprecatedAnnotation(Immutable.class);
    private final MetaModelValidatorForDeprecatedAnnotation objectTypeValidator = new MetaModelValidatorForDeprecatedAnnotation(ObjectType.class);
    private IsisConfiguration configuration;
    private AdapterManager adapterManager;
    private ServicesInjector servicesInjector;
    private QuerySubmitter querySubmitter;

    public DomainObjectAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        this.processAuditing(processClassContext);
        this.processPublishing(processClassContext);
        this.processAutoComplete(processClassContext);
        this.processBounded(processClassContext);
        this.processEditing(processClassContext);
        this.processObjectType(processClassContext);
        this.processNature(processClassContext);
    }

    void processAuditing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object holder = processClassContext.getFacetHolder();
        if (HasTransactionId.class.isAssignableFrom(cls)) {
            return;
        }
        Audited annotation = Annotations.getAnnotation(cls, Audited.class);
        AuditableFacet auditableFacet = this.auditedValidator.flagIfPresent(AuditableFacetForAuditedAnnotation.create(annotation, holder), null);
        if (auditableFacet == null) {
            auditableFacet = AuditableFacetForDomainObjectAnnotation.create(domainObject, this.configuration, holder);
        }
        FacetUtil.addFacet(auditableFacet);
    }

    void processPublishing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        if (HasTransactionId.class.isAssignableFrom(cls)) {
            return;
        }
        PublishedObject publishedObject = Annotations.getAnnotation(processClassContext.getCls(), PublishedObject.class);
        PublishedObjectFacet publishedObjectFacet = this.publishedObjectValidator.flagIfPresent(PublishedObjectFacetForPublishedObjectAnnotation.create(publishedObject, facetHolder));
        if (publishedObjectFacet == null) {
            publishedObjectFacet = PublishedObjectFacetForDomainObjectAnnotation.create(domainObject, this.configuration, facetHolder);
        }
        FacetUtil.addFacet(publishedObjectFacet);
    }

    void processAutoComplete(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        AutoComplete annotation = Annotations.getAnnotation(processClassContext.getCls(), AutoComplete.class);
        AutoCompleteFacet facet = this.autoCompleteValidator.flagIfPresent(AutoCompleteFacetForAutoCompleteAnnotation.create(annotation, this.getSpecificationLoader(), this.adapterManager, this.servicesInjector, facetHolder));
        if (facet == null) {
            facet = AutoCompleteFacetForDomainObjectAnnotation.create(domainObject, this.getSpecificationLoader(), this.adapterManager, this.servicesInjector, facetHolder);
        }
        FacetUtil.addFacet(facet);
    }

    void processBounded(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        Bounded annotation = Annotations.getAnnotation(processClassContext.getCls(), Bounded.class);
        Facet facet = this.boundedValidator.flagIfPresent(ChoicesFacetFromBoundedAnnotation.create(annotation, this.querySubmitter, processClassContext.getFacetHolder()));
        if (facet == null) {
            facet = ChoicesFacetForDomainObjectAnnotation.create(domainObject, this.querySubmitter, facetHolder);
        }
        FacetUtil.addFacet(facet);
    }

    void processEditing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        Immutable annotation = Annotations.getAnnotation(processClassContext.getCls(), Immutable.class);
        ImmutableFacet facet = this.immutableValidator.flagIfPresent(ImmutableFacetForImmutableAnnotation.create(annotation, processClassContext.getFacetHolder()));
        if (facet == null) {
            facet = ImmutableFacetForDomainObjectAnnotation.create(domainObject, this.configuration, facetHolder);
        }
        FacetUtil.addFacet(facet);
    }

    void processObjectType(FacetFactory.ProcessClassContext processClassContext) {
        JdoPersistenceCapableFacet jdoPersistenceCapableFacet;
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        JdoPersistenceCapableFacet facetHolder = processClassContext.getFacetHolder();
        ObjectType annotation = Annotations.getAnnotation(processClassContext.getCls(), ObjectType.class);
        ObjectSpecIdFacet facet = this.objectTypeValidator.flagIfPresent(ObjectSpecIdFacetFromObjectTypeAnnotation.create(annotation, processClassContext.getFacetHolder()));
        if (facet == null) {
            facet = ObjectSpecIdFacetForDomainObjectAnnotation.create(domainObject, facetHolder);
        }
        if (facet == null && (jdoPersistenceCapableFacet = facetHolder.getFacet(JdoPersistenceCapableFacet.class)) != null) {
            facet = ObjectSpecIdFacetForJdoPersistenceCapableAnnotation.create(jdoPersistenceCapableFacet, facetHolder);
        }
        FacetUtil.addFacet(facet);
    }

    void processNature(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        ViewModelFacet facet = RecreatableObjectFacetForDomainObjectAnnotation.create(domainObject, this.getSpecificationLoader(), this.adapterManager, this.servicesInjector, facetHolder);
        FacetUtil.addFacet(facet);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification thisSpec, ValidationFailures validationFailures) {
                HashMap specById = Maps.newHashMap();
                Collection<ObjectSpecification> allSpecifications = DomainObjectAnnotationFacetFactory.this.getSpecificationLoader().allSpecifications();
                for (ObjectSpecification otherSpec : allSpecifications) {
                    ObjectSpecification existingSpec;
                    ObjectSpecId objectSpecId;
                    if (thisSpec == otherSpec || (objectSpecId = otherSpec.getSpecId()) == null || (existingSpec = specById.put(objectSpecId, otherSpec)) == null) continue;
                    validationFailures.add("%s: cannot have two entities with same object type (@DomainObject(objectType=...) or @ObjectType); %s has same value (%s).", existingSpec.getFullIdentifier(), otherSpec.getFullIdentifier(), objectSpecId);
                }
                return true;
            }
        }));
        metaModelValidator.add(this.publishedObjectValidator);
        metaModelValidator.add(this.auditedValidator);
        metaModelValidator.add(this.autoCompleteValidator);
        metaModelValidator.add(this.boundedValidator);
        metaModelValidator.add(this.immutableValidator);
        metaModelValidator.add(this.objectTypeValidator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
        this.publishedObjectValidator.setConfiguration(configuration);
        this.auditedValidator.setConfiguration(configuration);
        this.autoCompleteValidator.setConfiguration(configuration);
        this.boundedValidator.setConfiguration(configuration);
        this.immutableValidator.setConfiguration(configuration);
        this.objectTypeValidator.setConfiguration(configuration);
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }

    @Override
    public void setQuerySubmitter(QuerySubmitter querySubmitter) {
        this.querySubmitter = querySubmitter;
    }
}

