/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.hidden.method;

import java.lang.reflect.Method;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.hidden.HiddenObjectFacet;
import org.apache.isis.core.metamodel.facets.object.hidden.method.HiddenObjectFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class HiddenObjectFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String HIDDEN_PREFIX = "hidden";
    private static final String[] PREFIXES = new String[]{"hidden"};

    public HiddenObjectFacetViaMethodFactory() {
        super(FeatureType.EVERYTHING_BUT_PARAMETERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        for (Class returnType : new Class[]{Boolean.class, Boolean.TYPE}) {
            if (!this.addFacetIfMethodFound(processClassContext, returnType)) continue;
            return;
        }
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod member = (FacetedMethod)processMethodContext.getFacetHolder();
        Class<?> owningClass = processMethodContext.getCls();
        ObjectSpecification owningSpec = this.getSpecificationLoader().loadSpecification(owningClass);
        HiddenObjectFacet facet = owningSpec.getFacet(HiddenObjectFacet.class);
        if (facet != null) {
            facet.copyOnto(member);
        }
    }

    private boolean addFacetIfMethodFound(FacetFactory.ProcessClassContext processClassContext, Class<?> returnType) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, HIDDEN_PREFIX, returnType, NO_PARAMETERS_TYPES);
        if (method == null) {
            return false;
        }
        FacetUtil.addFacet(new HiddenObjectFacetViaMethod(method, (FacetHolder)facetHolder));
        processClassContext.removeMethod(method);
        return true;
    }
}

