/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.parseable.annotcfg;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Parseable;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.parseable.ParserUtil;
import org.apache.isis.core.metamodel.facets.object.parseable.annotcfg.ParseableFacetAnnotation;
import org.apache.isis.core.metamodel.facets.object.parseable.annotcfg.ParseableFacetFromConfiguration;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAware;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class ParseableFacetAnnotationElseConfigurationFactory
extends FacetFactoryAbstract
implements IsisConfigurationAware,
AuthenticationSessionProviderAware,
AdapterManagerAware,
ServicesInjectorAware,
RuntimeContextAware {
    private IsisConfiguration configuration;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private AdapterManager adapterManager;
    private ServicesInjector servicesInjector;
    private RuntimeContext runtimeContext;

    public ParseableFacetAnnotationElseConfigurationFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetUtil.addFacet(this.create(processClassContaxt.getCls(), (FacetHolder)processClassContaxt.getFacetHolder()));
    }

    private ParseableFacetAbstract create(Class<?> cls, FacetHolder holder) {
        ParseableFacetFromConfiguration facet;
        ParseableFacetAnnotation facet2;
        Parseable annotation = Annotations.getAnnotation(cls, Parseable.class);
        if (annotation != null && (facet2 = new ParseableFacetAnnotation(cls, this.getIsisConfiguration(), holder, this.getDeploymentCategory(), this.authenticationSessionProvider, this.adapterManager, this.servicesInjector)).isValid()) {
            return facet2;
        }
        String parserName = ParserUtil.parserNameFromConfiguration(cls, this.getIsisConfiguration());
        if (!Strings.isNullOrEmpty((String)parserName) && (facet = new ParseableFacetFromConfiguration(parserName, holder, this.getDeploymentCategory(), this.authenticationSessionProvider, this.servicesInjector, this.adapterManager)).isValid()) {
            return facet;
        }
        return null;
    }

    private DeploymentCategory getDeploymentCategory() {
        return this.runtimeContext.getDeploymentCategory();
    }

    public IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setAuthenticationSessionProvider(AuthenticationSessionProvider authenticationSessionProvider) {
        this.authenticationSessionProvider = authenticationSessionProvider;
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    @Override
    public void setServicesInjector(ServicesInjector dependencyInjector) {
        this.servicesInjector = dependencyInjector;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

