/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.recreatable;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

public abstract class RecreatableObjectFacetDeclarativeAbstract
extends RecreatableObjectFacetAbstract {
    private final SpecificationLoader specificationLoader;
    private final ServicesInjector servicesInjector;
    private final AdapterManager adapterManager;

    public RecreatableObjectFacetDeclarativeAbstract(FacetHolder holder, ViewModelFacet.ArchitecturalLayer architecturalLayer, SpecificationLoader specificationLoader, AdapterManager adapterManager, ServicesInjector servicesInjector) {
        super(holder, architecturalLayer);
        this.specificationLoader = specificationLoader;
        this.servicesInjector = servicesInjector;
        this.adapterManager = adapterManager;
    }

    @Override
    public void initialize(Object viewModelPojo, String mementoStr) {
        MementoService mementoService = this.servicesInjector.lookupService(MementoService.class);
        BookmarkService bookmarkService = this.servicesInjector.lookupService(BookmarkService.class);
        MementoService.Memento memento = mementoService.parse(mementoStr);
        Set mementoKeys = memento.keySet();
        ObjectAdapter viewModelAdapter = this.adapterManager.getAdapterFor(viewModelPojo);
        if (viewModelAdapter == null) {
            ObjectSpecification objectSpecification = this.specificationLoader.loadSpecification(viewModelPojo.getClass());
            ObjectSpecId objectSpecId = objectSpecification.getSpecId();
            viewModelAdapter = this.adapterManager.mapRecreatedPojo(new RootOidDefault(objectSpecId, mementoStr, Oid.State.VIEWMODEL), viewModelPojo);
        }
        ObjectSpecification spec = viewModelAdapter.getSpecification();
        List<OneToOneAssociation> properties = spec.getProperties(Contributed.EXCLUDED);
        for (OneToOneAssociation property : properties) {
            String propertyId = property.getId();
            Object propertyValue = null;
            if (mementoKeys.contains(propertyId)) {
                Class<?> propertyType = property.getSpecification().getCorrespondingClass();
                propertyValue = memento.get(propertyId, propertyType);
            } else if (mementoKeys.contains(propertyId + ".bookmark")) {
                Bookmark propertyValueBookmark = (Bookmark)memento.get(propertyId + ".bookmark", Bookmark.class);
                propertyValue = bookmarkService.lookup(propertyValueBookmark);
            }
            if (propertyValue == null) continue;
            property.set(viewModelAdapter, this.adapterManager.adapterFor(propertyValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String memento(Object viewModelPojo) {
        MementoService mementoService = this.servicesInjector.lookupService(MementoService.class);
        BookmarkService bookmarkService = this.servicesInjector.lookupService(BookmarkService.class);
        MementoService.Memento memento = mementoService.create();
        boolean createdTemporaryAdapter = false;
        ObjectAdapter viewModelAdapter = this.adapterManager.getAdapterFor(viewModelPojo);
        if (viewModelAdapter == null) {
            ObjectSpecification objectSpecification = this.specificationLoader.loadSpecification(viewModelPojo.getClass());
            ObjectSpecId objectSpecId = objectSpecification.getSpecId();
            viewModelAdapter = this.adapterManager.mapRecreatedPojo(RootOidDefault.create(objectSpecId, UUID.randomUUID().toString()), viewModelPojo);
            createdTemporaryAdapter = true;
        }
        try {
            ObjectSpecification spec = viewModelAdapter.getSpecification();
            List<OneToOneAssociation> properties = spec.getProperties(Contributed.EXCLUDED);
            for (OneToOneAssociation property : properties) {
                ObjectAdapter propertyValueAdapter;
                if (!property.containsDoOpFacet(PropertySetterFacet.class) || property.isNotPersisted() || (propertyValueAdapter = property.get(this.adapterManager.adapterFor(viewModelPojo))) == null) continue;
                Object propertyValue = propertyValueAdapter.getObject();
                if (mementoService.canSet(propertyValue)) {
                    memento.set(property.getId(), propertyValue);
                    continue;
                }
                Bookmark propertyValueBookmark = bookmarkService.bookmarkFor(propertyValue);
                memento.set(property.getId() + ".bookmark", (Object)propertyValueBookmark);
            }
            String string = memento.asString();
            return string;
        }
        finally {
            if (createdTemporaryAdapter) {
                this.adapterManager.removeAdapter(viewModelAdapter);
            }
        }
    }
}

