/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.recreatable;

import org.apache.isis.applib.RecreatableDomainObject;
import org.apache.isis.applib.annotation.ViewModel;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForRecreatableDomainObjectInterface;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForViewModelAnnotation;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForViewModelInterface;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class RecreatableObjectFacetFactory
extends FacetFactoryAbstract
implements ServicesInjectorAware,
AdapterManagerAware,
MetaModelValidatorRefiner {
    private ServicesInjector servicesInjector;
    private AdapterManager adapterManager;

    public RecreatableObjectFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        if (org.apache.isis.applib.ViewModel.class.isAssignableFrom(processClassContext.getCls())) {
            FacetUtil.addFacet(new RecreatableObjectFacetForViewModelInterface((FacetHolder)processClassContext.getFacetHolder()));
        }
        ViewModel annotation = Annotations.getAnnotation(processClassContext.getCls(), ViewModel.class);
        FacetUtil.addFacet(this.create(annotation, (FacetHolder)processClassContext.getFacetHolder()));
        if (RecreatableDomainObject.class.isAssignableFrom(processClassContext.getCls())) {
            FacetUtil.addFacet(new RecreatableObjectFacetForRecreatableDomainObjectInterface((FacetHolder)processClassContext.getFacetHolder()));
        }
    }

    private ViewModelFacet create(ViewModel annotation, FacetHolder holder) {
        return annotation != null ? new RecreatableObjectFacetForViewModelAnnotation(holder, this.getSpecificationLoader(), this.adapterManager, this.servicesInjector) : null;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                Facet underlyingFacet;
                ViewModelFacet facet = objectSpec.getFacet(ViewModelFacet.class);
                Facet facet2 = underlyingFacet = facet != null ? facet.getUnderlyingFacet() : null;
                if (underlyingFacet != null) {
                    validationFailures.add("%s: has multiple incompatible annotations/interfaces indicating that it is a recreatable object of some sort (%s and %s)", objectSpec.getFullIdentifier(), facet.getClass().getSimpleName(), underlyingFacet.getClass().getSimpleName());
                }
                return true;
            }
        }));
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }
}

