/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.autocomplete;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.MinLength;
import org.apache.isis.applib.annotation.Parameter;

public final class MinLengthUtil {
    public static final int MIN_LENGTH_DEFAULT = 1;

    private MinLengthUtil() {
    }

    public static int determineMinLength(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length == 1) {
            Annotation[] searchArgAnnotations;
            for (Annotation annotation : searchArgAnnotations = parameterAnnotations[0]) {
                if (annotation instanceof MinLength) {
                    MinLength minLength = (MinLength)annotation;
                    return minLength.value();
                }
                if (!(annotation instanceof Parameter)) continue;
                Parameter parameter = (Parameter)annotation;
                return parameter.minLength();
            }
        }
        return 1;
    }
}

