/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.layout;

import java.lang.annotation.Annotation;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.param.layout.CssClassFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.DescribedAsFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.LabelAtFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.MultiLineFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.NamedFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.RenderedAdjustedFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.TypicalLengthFacetForParameterLayoutAnnotation;

public class ParameterLayoutFacetFactory
extends FacetFactoryAbstract {
    public ParameterLayoutFacetFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Class<?>[] parameterTypes = processParameterContext.getMethod().getParameterTypes();
        if (processParameterContext.getParamNum() >= parameterTypes.length) {
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(processParameterContext.getMethod())[processParameterContext.getParamNum()]) {
            if (!(parameterAnnotation instanceof ParameterLayout)) continue;
            ParameterLayout parameterLayout = (ParameterLayout)parameterAnnotation;
            this.addFacets(processParameterContext, parameterLayout);
            return;
        }
    }

    protected void addFacets(FacetFactory.ProcessParameterContext processParameterContext, ParameterLayout parameterLayout) {
        FacetedMethodParameter facetHolder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        FacetUtil.addFacet(CssClassFacetForParameterLayoutAnnotation.create(parameterLayout, facetHolder));
        FacetUtil.addFacet(DescribedAsFacetForParameterLayoutAnnotation.create(parameterLayout, facetHolder));
        FacetUtil.addFacet(LabelAtFacetForParameterLayoutAnnotation.create(parameterLayout, facetHolder));
        FacetUtil.addFacet(MultiLineFacetForParameterLayoutAnnotation.create(parameterLayout, facetHolder));
        FacetUtil.addFacet(NamedFacetForParameterLayoutAnnotation.create(parameterLayout, facetHolder));
        FacetUtil.addFacet(RenderedAdjustedFacetForParameterLayoutAnnotation.create(parameterLayout, facetHolder));
        FacetUtil.addFacet(TypicalLengthFacetForParameterLayoutAnnotation.create(parameterLayout, facetHolder));
    }
}

