/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.multiline.annotation;

import java.lang.annotation.Annotation;
import org.apache.isis.applib.annotation.MultiLine;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacetInferredFromMultiLineFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.core.metamodel.facets.param.multiline.annotation.MultiLineFacetOnParameterAnnotation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class MultiLineFacetOnParameterAnnotationFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner,
IsisConfigurationAware {
    private final MetaModelValidatorForDeprecatedAnnotation validator = new MetaModelValidatorForDeprecatedAnnotation(MultiLine.class);

    public MultiLineFacetOnParameterAnnotationFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Class<?>[] parameterTypes = processParameterContext.getMethod().getParameterTypes();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        int paramNum = processParameterContext.getParamNum();
        if (paramNum >= parameterTypes.length) {
            return;
        }
        Class<?> parameterType = parameterTypes[paramNum];
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(processParameterContext.getMethod())[paramNum]) {
            if (!(parameterAnnotation instanceof MultiLine)) continue;
            MultiLine annotation = (MultiLine)parameterAnnotation;
            MultiLineFacet multiLineFacet = MultiLineFacetOnParameterAnnotation.create(annotation, parameterType, holder);
            FacetUtil.addFacet(this.validator.flagIfPresent(multiLineFacet, processParameterContext));
            MultiLineFacet facet = multiLineFacet;
            MultiLineFacetOnParameterAnnotationFactory.inferPropParamLayoutFacet(facet);
            return;
        }
    }

    private static void inferPropParamLayoutFacet(MultiLineFacet facet) {
        if (facet == null) {
            return;
        }
        FacetUtil.addFacet(new LabelAtFacetInferredFromMultiLineFacet(facet.getFacetHolder()));
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.validator.setConfiguration(configuration);
    }
}

