/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.accessor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacetAbstract;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;

public class PropertyAccessorFacetViaAccessor
extends PropertyOrCollectionAccessorFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public PropertyAccessorFacetViaAccessor(Method method, FacetHolder holder, AdapterManager adapterManager, SpecificationLoader specificationLoader, IsisConfiguration isisConfiguration) {
        super(holder, adapterManager, specificationLoader, isisConfiguration);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.ACCESSOR;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public Object getProperty(ObjectAdapter owningAdapter, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        ObjectAdapter referencedAdapter;
        boolean visible;
        Object referencedObject = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        if (referencedObject == null) {
            return null;
        }
        boolean filterForVisibility = this.getConfiguration().getBoolean("isis.reflector.facet.propertyAccessor.filterVisibility", true);
        if (filterForVisibility && !(visible = ObjectAdapter.Util.isVisible(referencedAdapter = this.getAdapterManager().adapterFor(referencedObject), authenticationSession, deploymentCategory))) {
            return null;
        }
        return referencedObject;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

