/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.autocomplete.method;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.MinLengthUtil;
import org.apache.isis.core.metamodel.facets.properties.autocomplete.PropertyAutoCompleteFacetAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;

public class PropertyAutoCompleteFacetMethod
extends PropertyAutoCompleteFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesClass;
    private final int minLength;
    private final AdapterManager adapterManager;
    private SpecificationLoader specificationLoader;

    public PropertyAutoCompleteFacetMethod(Method method, Class<?> choicesClass, FacetHolder holder, SpecificationLoader specificationLoader, AdapterManager adapterManager) {
        super(holder);
        this.method = method;
        this.choicesClass = choicesClass;
        this.specificationLoader = specificationLoader;
        this.adapterManager = adapterManager;
        this.minLength = MinLengthUtil.determineMinLength(method);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public Object[] autoComplete(ObjectAdapter owningAdapter, String searchArg, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        Object collectionOrArray = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter, searchArg);
        if (collectionOrArray == null) {
            return null;
        }
        ObjectAdapter collectionAdapter = this.getAdapterManager().adapterFor(collectionOrArray);
        FacetedMethod facetedMethod = (FacetedMethod)this.getFacetHolder();
        Class<?> propertyType = facetedMethod.getType();
        List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, authenticationSession, deploymentCategory);
        ArrayList filteredObjects = Lists.newArrayList((Iterable)Iterables.transform(visibleAdapters, ObjectAdapter.Functions.getObject()));
        ObjectSpecification propertySpec = this.getSpecification(propertyType);
        return CollectionUtils.getCollectionAsObjectArray(filteredObjects, propertySpec, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",class=" + this.choicesClass;
    }

    protected ObjectSpecification getSpecification(Class<?> type) {
        return type != null ? this.getSpecificationLoader().loadSpecification(type) : null;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }
}

