/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.multiline.annotation;

import java.util.Properties;
import org.apache.isis.applib.annotation.MultiLine;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacetInferredFromMultiLineFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.core.metamodel.facets.properties.multiline.annotation.MultiLineFacetOnPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.multiline.annotation.MultiLineFacetOnPropertyFromProperties;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class MultiLineFacetOnPropertyFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
MetaModelValidatorRefiner,
IsisConfigurationAware {
    private final MetaModelValidatorForDeprecatedAnnotation multiLineValidator = new MetaModelValidatorForDeprecatedAnnotation(MultiLine.class);

    public MultiLineFacetOnPropertyFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        MultiLineFacet facet = MultiLineFacetOnPropertyFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (facet == null) {
            facet = this.multiLineValidator.flagIfPresent(MultiLineFacetOnPropertyFactory.createFromAnnotationIfPossible(processMethodContext), processMethodContext);
        }
        FacetUtil.addFacet(facet);
        MultiLineFacetOnPropertyFactory.inferLabelAtFacet(facet);
    }

    private static void inferLabelAtFacet(MultiLineFacet facet) {
        if (facet == null) {
            return;
        }
        FacetUtil.addFacet(new LabelAtFacetInferredFromMultiLineFacet(facet.getFacetHolder()));
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
    }

    private static MultiLineFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("multiLine");
        return properties != null ? new MultiLineFacetOnPropertyFromProperties(properties, holder) : null;
    }

    private static MultiLineFacetOnPropertyAnnotation createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        if (!Annotations.isString(returnType)) {
            return null;
        }
        MultiLine annotation = Annotations.getAnnotation(processMethodContext.getMethod(), MultiLine.class);
        return annotation != null ? new MultiLineFacetOnPropertyAnnotation(annotation.numberOfLines(), annotation.preventWrapping(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.multiLineValidator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.multiLineValidator.setConfiguration(configuration);
    }
}

