/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.modify;

import com.google.common.base.Objects;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.PropertyDomainEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;

public abstract class PropertySetterFacetForDomainEventAbstract
extends SingleValueFacetAbstract<Class<? extends PropertyDomainEvent<?, ?>>>
implements PropertySetterFacet {
    private final DomainEventHelper domainEventHelper;
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final PropertySetterFacet setterFacet;
    private final PropertyDomainEventFacetAbstract propertyDomainEventFacet;

    public static Class<? extends Facet> type() {
        return PropertySetterFacet.class;
    }

    public PropertySetterFacetForDomainEventAbstract(Class<? extends PropertyDomainEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, PropertySetterFacet setterFacet, PropertyDomainEventFacetAbstract propertyDomainEventFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(PropertySetterFacetForDomainEventAbstract.type(), eventType, holder);
        this.getterFacet = getterFacet;
        this.setterFacet = setterFacet;
        this.propertyDomainEventFacet = propertyDomainEventFacet;
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    @Override
    public void setProperty(ObjectAdapter targetAdapter, ObjectAdapter newValueAdapter) {
        if (this.setterFacet == null) {
            return;
        }
        if (!this.domainEventHelper.hasEventBusService()) {
            this.setterFacet.setProperty(targetAdapter, newValueAdapter);
            return;
        }
        Object oldValue = this.getterFacet.getProperty(targetAdapter, null, null);
        Object newValue = ObjectAdapter.Util.unwrap(newValueAdapter);
        PropertyDomainEvent<?, ?> event = this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.EXECUTING, this.eventType(), null, this.getIdentified(), targetAdapter, oldValue, newValue);
        this.setterFacet.setProperty(targetAdapter, newValueAdapter);
        Object actualNewValue = this.getterFacet.getProperty(targetAdapter, null, null);
        if (Objects.equal((Object)oldValue, (Object)actualNewValue)) {
            return;
        }
        this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.EXECUTED, this.eventType(), this.verify(event), this.getIdentified(), targetAdapter, oldValue, actualNewValue);
    }

    private Class<? extends PropertyDomainEvent<?, ?>> eventType() {
        return (Class)this.value();
    }

    protected PropertyDomainEvent<?, ?> verify(PropertyDomainEvent<?, ?> event) {
        return event;
    }
}

