/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.update;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacetViaModifyMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class PropertyModifyFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements ServicesInjectorAware {
    private static final String[] PREFIXES = new String[]{"modify"};
    private ServicesInjector servicesInjector;

    public PropertyModifyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachPropertyModifyFacetIfModifyMethodIsFound(processMethodContext);
    }

    private void attachPropertyModifyFacetIfModifyMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Class<?> returnType = getMethod.getReturnType();
        Class[] paramTypes = new Class[]{returnType};
        Class<?> cls = processMethodContext.getCls();
        Method modifyMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "modify" + capitalizedName, Void.TYPE, paramTypes);
        if (modifyMethod == null) {
            return;
        }
        processMethodContext.removeMethod(modifyMethod);
        Object property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new PropertySetterFacetViaModifyMethod(modifyMethod, (FacetHolder)property, this.servicesInjector));
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

