/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.update.modify;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacetAbstract;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;

public class PropertySetterFacetViaModifyMethod
extends PropertySetterFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final ServicesInjector servicesInjector;

    public PropertySetterFacetViaModifyMethod(Method method, FacetHolder holder, ServicesInjector servicesInjector) {
        super(holder);
        this.method = method;
        this.servicesInjector = servicesInjector;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.MODIFY_PROPERTY_SUPPORTING;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return true;
    }

    @Override
    public void setProperty(ObjectAdapter targetAdapter, ObjectAdapter valueAdapter) {
        CommandContext commandContext = this.getServicesInjector().lookupService(CommandContext.class);
        if (commandContext != null) {
            Command command = commandContext.getCommand();
            command.setExecutor(Command.Executor.USER);
            command.setTarget(CommandUtil.bookmarkFor(targetAdapter));
            command.setTargetClass(CommandUtil.targetClassNameFor(targetAdapter));
            command.setTargetAction("(edit)");
            command.setMemberIdentifier("(edit)");
            command.setExecuteIn(Command.ExecuteIn.FOREGROUND);
            command.setPersistence(Command.Persistence.IF_HINTED);
            command.setStartedAt(Clock.getTimeAsJavaSqlTimestamp());
        }
        ObjectAdapter.InvokeUtils.invoke(this.method, targetAdapter, valueAdapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    private ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }
}

